/*

             **************************************************
             ****            VEGA - IFF MOLE V1.2          ****
             ****               Loader & Saver             ****
             **** Copyright 1996-2000, Alessandro Pedretti ****
             **************************************************


Uses an Amiga IFF chunk structure to save molecule.
All chunks are optional !

*/

#include <stdio.h>
#include <string.h>

#include "locale.h"

/**** Local prototypes ****/

#ifdef LITTLE_ENDIAN
static void Swap(void *);
#endif

/**** Open an IFF file for read ****/
/**** and eventually check it   ****/

FILE *OpenIff(char *Name, unsigned int Comp)
{
  FILE           *FH = NULL;
  IFFHDR         Hdr;

  if (FH = fopen(Name, "rb")) {
    if (ReadIffHdr(FH, &Hdr, IFF_FORM)) {
      if (fread(&Hdr, sizeof(unsigned int), 1, FH) == 1) {

#ifdef LITTLE_ENDIAN
        Swap(&Hdr.ID);
#endif

        if (Comp != Hdr.ID) {
          fclose(FH);
          FH = NULL;
        }
      } else {
        PrintDosErr();
        fclose(FH);
        FH = NULL;
      }
    }
  }

  return FH;
}






