
/*************************************************
****            Locale library V1.1           ****
****               Public header              ****
**** Copyright 2000-2002, Alessandro Pedretti ****
**************************************************/

/*
 * Define LOCALE_DLL to use and compile LOCALE.DLL
 * for Win32.
 */

#ifndef __LOCALE_HDR
#define  __LOCALE_HDR

/**** Boolean constants ****/

#ifndef FALSE
#  define  FALSE    0
#endif
#ifndef TRUE
#  define  TRUE     1
#endif

#define  LOCALE_DIR   "Catalogs"

/**** Windows specific definitions ****/

#if defined(_WINDOWS) || defined(WINDOWS) || defined(_WIN32) || defined(_WIN32_)
#  ifndef WIN32
#    define WIN32
#endif

#  ifndef LITTLE_ENDIAN
#    define  LITTLE_ENDIAN
#  endif

#  ifdef LOCALE_DLL
#    include <windows.h>
#    ifdef __MINGW32__
#      define  LOCEXPORT(func)     func
#      define  LOCEXTERN           __declspec(dllexport)
#    else
#      define  LOCEXPORT(func)     __declspec(dllexport) WINAPI (func)
#    endif
#  endif
#  ifdef LOCALE_DYNDLL
#    define LOCEXPORT(func) (WINAPI * func)
#    define LOCEXTERN           extern
#  endif

/**** Windows CE ****/

#  ifdef _WIN32_WCE
#    define  strcasecmp         _stricmp
#    define  strncasecmp        _strnicmp
#  else
#    ifndef strcasecmp
#      define  strcasecmp       strcmpi
#    endif
#    ifndef strncasecmp
#      define  strncasecmp      strnicmp
#    endif
#  endif

#  ifndef C_DIRSEP
#    define  C_DIRSEP     "\\"
#  endif

/**** Other operating systems ****/

#else
#  ifndef C_DIRSEP
#    define  C_DIRSEP     "/"
#  endif
#endif

#ifndef LOCEXTERN
#define  LOCEXTERN        extern
#endif

#ifndef LOCEXPORT
#  define  LOCEXPORT
#endif


/**** Error codes ****/

#define  LOCERR_NONE          0         /* No errors                                  */
#define  LOCERR_DOS           1         /* Dos error                                  */
#define  LOCERR_CORRUPT       2         /* Corrupted catalog file                     */
#define  LOCERR_VERSION       3         /* Catalog version incompatible               */
#define  LOCERR_MEMORY        4         /* Not enough memory                          */
#define  LOCERR_ANOTHERAPP    5         /* Catalog of another application             */
#define  LOCERR_LANGUAGE      6         /* Catalog in another language                */
#define  LOCERR_AUTONOTSUP    7         /* Automatic language selection not supported */
#define  LOCERR_AUTOWIN       8         /* Error detecting the system language        */
#define  LOCERR_NOTFOUND      9         /* Catalog file not found                     */
#define  LOCERR_LANGSTR      10         /* Laguage string not found                   */


/**** Structure required by LocAmigaVer() command ****/

typedef struct {
  unsigned int  Ver, Rel;
  char          Name[32];
  char          Date[14];
} AMIGAVER;


/**** Function macros for compatibility ****/

#define  Dos2Iso(STR)           LocIso2Dos((STR), 1)
/*
#define  DosPrintf              LocDosPrintf
*/
#define  Iso2Dos(STR)           LocIso2Dos((STR), 0)
#define  StrCpyDos              LocStrCpy


/**** Prototypes ****/

#  ifdef __cplusplus
   extern "C" {
#  endif

LOCEXTERN void    LOCEXPORT(LocAmigaVer)(char *, AMIGAVER *);
/*
 * void LocAmigaVer(char *Ptr, AMIGAVER *Ver)
 *
 * It returns the name, the date, the version and the release of an AmigaDOS file,
 * loaded in memory at the Ptr location.
 * These informations are returned in Ver structure pointer.
 */

LOCEXTERN void    LOCEXPORT(LocCloseCat)(void *);
/*
 * void LocCloseCat(void *Cat)
 *
 * It closes a catalog, deallocanting the memory and the resources. Cat is the catalog
 * pointer.
 */

LOCEXTERN int     LOCEXPORT(LocDosPrintf)(FILE *, char *, ...);
/*
 * int LocDosPrintf(FILE *FH, char *AnsiStr, ...)
 *
 * This function replaces the standard fprintf and adds the capability to change
 * the character set from ANSI/ISO into Ms-Dos. It returns the number of
 * charaters printed out, or -1 if an error occurs.
 */

LOCEXTERN void    LOCEXPORT(LocIso2Dos)(char *, short);
/*
 * void LocIso2Dos(char *Str, short Back)
 *
 * It converts the string Str from ANSI/ISO into Ms-Dos (Back = FALSE) format, or
 * from Ms-Dos into ANSI/ISO (Back = TRUE).
 */

LOCEXTERN char  * LOCEXPORT(LocGetCatStr)(void *, unsigned int, char *);
/*
 * char *LocGetCatStr(void *Cat, unsigned int StrID, char *BuiltIn)
 *
 * It translates a string indicating the catalog (Cat pointer, opened with
 * LocOpenCat()), the string identification number (StrID) and the string array
 * BuiltIn that contains all strings in built-in language.
 * The returned value is the pointer to the translated string.
 */

LOCEXTERN int     LOCEXPORT(LocGetErr)(void);
/*
 * int LocGetErr(void)
 *
 * This function returns the error code if a function of locale library fails. If
 * no error, it returns LOCERR_NONE (0). See the error codes section.
 */

LOCEXTERN void    LOCEXPORT(LocGetErrStr)(char *, int);
/*
 * void LocGetErrStr(char *Buffer, int Size)
 *
 * It returns the complete error message in the Buffer string with Size
 * dimension.
 */

LOCEXTERN void  * LOCEXPORT(LocOpenCat)(char *, char *, char *, unsigned int, char *);
/*
 * void *LocOpenCat(char *CatName, char *CatDir, char *Lang, unsigned int Ver, char *BuiltIn)
 *
 * This function opens and loads into the memory the catalog file with CatName
 * name, placed in CatDir directory, with Lang language and with Ver version.
 * If Lang is "auto", the automatic detection of the system language is enabled.
 * This function isn't available with all operating systems. If isn't possible,
 * the LOCERR_AUTONOTSUP error code is reported.
 * BuiltIn is the name of the built-in language (e.g. "english").
 * It returns the memory pointer to manage the catalog.
 */

LOCEXTERN void   LOCEXPORT(LocStrCpy)(char *, char *);
/*
 * void LocStrCpy(char *Dest, char *Src)
 *
 * strcpy() replacement with ANSI/ISO into Ms-Dos charater set conversion.
 */


/**** Specific Win32 functions ****/

#  ifdef WIN32
LOCEXTERN char  * LOCEXPORT(LocGetLangStr)(void);
/*
 * char *LocGetLangStr(void)
 *
 * Return the string pointer of the current system language. See the include
 * tables.h.
 */
#  endif

#  ifdef __cplusplus
   }
#  endif
#endif
