
/*************************************************
****         VEGA - Alchemy loader            ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#include <ctype.h>
#include <stdio.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"


#ifdef LITTLE_ENDIAN
#  define  FF_TRIPOS_C2     0x00322e43
#else
#  define  FF_TRIPOS_C2     0x432e3200
#endif

/**** Alchemy Loader ****/

ATOMO *AlchemyLoad(FILE *IN, RECORD *Lin, VG_ULONG *TotAtomi)
{
  char			Name[10];

  ATOMO			*InizAtm = NULL;
  register ATOMO	*Atm     = NULL;
  VG_ULONG              NumAtoms = 0;

  sscanf(Lin -> Line, "%d", &NumAtoms);
  while((NumAtoms) && (fgets(Lin -> Line, LINELEN, IN))) {
    if ((*Lin -> Line) && (*Lin -> Line != '\n')) {
      if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
        sscanf(Lin -> Line,"%*s %8s %f %f %f",
               Name, &Atm -> x, &Atm -> y, &Atm -> z);
        Str2Qchar(&Atm -> Name, Name);
        Atm -> Elem.C[0] = toupper(Atm -> Name.C[0]);
        if ((Atm -> Name.C[1]) && (islower(Atm -> Name.C[1])))
          Atm -> Elem.C[1] = Atm -> Name.C[1];
      } else break;
    }
    --NumAtoms;
  } /* End of while */

  if (Atm) {
    Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
    LastAtm       = Atm;
  }

  return InizAtm;
}


/**** Alchemy saver ****/

VG_BOOL AlchemySave(FILE *OUT, ATOMO *InizAtm, VG_ULONG TotAtm)
{
  ATOMO                 *Atm;
  char                  *BondName;
  VG_QCHAR		Ord1, Ord2, Ord3;
  register VG_UWORD	k;
  VG_ULONG              Count;

  VG_BOOL               Ret = TRUE;

#ifdef __VG_OPENGL
  VG_LONG               *Store = NULL;

  if (GLOBSW_OPENGL)
    Store = StoreFF(InizAtm, TotAtm);
#endif

  if ((Ret = AssignTriposFF(InizAtm, TotAtm))) {
    if (fprintf(OUT, "%5d ATOMS, %5d BONDS,     0 CHARGES\n",
                TotAtm, CountBond(InizAtm)) > 0) {
      Count = 1;
      for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
        if (fprintf(OUT, "%5d %-6.4s%8.4f %8.4f %8.4f     0.0000\n",
                     Count++, Atm -> Name.C, Atm -> x, Atm -> y, Atm -> z) <= 0) {
          Ret = PrintDosErr();
          break;
        }
      } /* End of for */

      /**** Bonds ****/

      if (Ret) {
        Count = 1;
        for(Atm = InizAtm; (Atm && Ret); Atm = Atm -> Ptr) {
          Ord1.L = AttToOrd(Atm);
          for(k = 0; ((Ret) && (k < Atm -> NSost)); ++k) {
            if (Atm -> Conn[k] -> Num > Atm -> Num) {
              Ord2.L = AttToOrd(Atm -> Conn[k]);
              if ((Ord1.L == 0x61720000) && (Ord2.L != 0x61720000)) Ord3.L = 0x31000000;
              else if ((Ord2.L == 0x61720000) && (Ord1.L != 0x61720000)) Ord3.L = 0x31000000;
                   else if (((Ord2.L == 0x616d0000) && (Atm -> Pot.L == FF_TRIPOS_C2)) ||
                            ((Ord1.L == 0x616d0000) && (Atm -> Conn[k] -> Pot.L == FF_TRIPOS_C2))) Ord3.L = 0x616d0000;
                        else if ((VG_ULONG)(Ord1.L) >= (VG_ULONG)(Ord2.L)) Ord3.L = Ord2.L;
                             else Ord3.L = Ord1.L;
#ifdef LITTLE_ENDIAN
              Swap(&Ord3.L);
#endif
              BondName = "SINGLE";
              switch(*Ord3.C) {
              case 'a':
                if (Ord3.C[1] == 'r') BondName = "AROMATIC";
                break;

              case '2':
                BondName = "DOUBLE";
                break;

              case '3':
                BondName = "TRIPLE";
                break;
              } /* End of switch */
              if (fprintf(OUT, "%5d  %4d  %4d  %s\n",
                          Count++, Atm -> Num, Atm -> Conn[k] -> Num, BondName) <= 0)
                Ret = PrintDosErr();
            }
          } /* End of for */
        } /* End of for */
      }
    } else Ret = PrintDosErr();
  }

#ifdef __VG_OPENGL
  if (Store) {
    RestoreFF(InizAtm, Store);
    FREE(Store);
  }
#endif

  return Ret;
}




