
/*************************************************
****     VEGA - Biosym loader & saver         ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/

/*
 * Supported Biosym formats:
 * - Archive 1     read & write
 * - Archive 3     read & write
 */


#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"


/**** Biosym Universal Loader ****/

ATOMO *CarLoad(FILE *CARIN, register RECORD *CarLin, VG_ULONG *TotAtomi)
{
  char              *FormStr, ResSeq[20];
  VG_LONG            k;

  register ATOMO     *Atm      = NULL;
  ATOMO              *InizAtm  = NULL;
  VG_LONG            SubFormat = 0;


  /**** Subformat recognition ****/

  sscanf(CarLin -> Line + 15, "%d", &SubFormat);
  if ((SubFormat < 1) || (SubFormat > 3)) CatErr(MSG_ERR_BIOSYM_NOTSUPPORTED);
  else {
    if ((SubFormat == 1) || (SubFormat == 2)) FormStr = "%s %s %f";
    else FormStr = "%s %s %*s %f";
    for(k = 0;k < 3;++k) fgets(CarLin -> Line, LINELEN, CARIN);
    while(fgets(CarLin -> Line, LINELEN, CARIN)) {
      if ((CarLin -> Hdr == *(VG_LONG *)"end\n") ||
          (CarLin -> Hdr == *(VG_LONG *)"end "))
        Atm -> Flags |= VG_ATMF_SEGEND;
      else if ((CarLin -> Hdr != *(VG_LONG *)"HELI") &&
               (CarLin -> Hdr != *(VG_LONG *)"PBC ") &&
               (*CarLin -> Line != '\n')) {
        if ((Atm = AllocAtm(&InizAtm, TotAtomi)) != NULL) {
          Atm -> ResName.L = NULL;
	  sscanf(CarLin -> Line, "%s %f %f %f %3s",
	         Atm -> Name.C, &Atm -> x, &Atm -> y, &Atm -> z, Atm -> ResName.C);
	  Atm -> ChainID = ' ';

          /**** Convert the residue name ****/

	  for(k = 0; *AAEquivTab[k].C; k += 2) {
	    if (AAEquivTab[k].L == Atm -> ResName.L) {
	      Atm -> ResName.L = AAEquivTab[k + 1].L;
	      break;
	    }
	  }

          /**** Element name ****/

          if ((SubFormat != 3) ||
              ((SubFormat == 3) && CarLin -> Line[71] == '?')) {
	    *Atm -> Elem.C = toupper(*Atm -> Name.C);
            if ((Atm -> Name.C[1]) && (islower(Atm -> Name.C[1])))
              Atm -> Elem.C[1] = Atm -> Name.C[1];
          } else {
            *Atm -> Elem.C = CarLin -> Line[71];
            if (CarLin -> Line[72] != ' ')
              Atm -> Elem.C[1] = CarLin -> Line[72];
          }
	  if (!strncmp(Atm -> ResName.C, "HOH", 3)) Atm -> Flags = VG_ATMF_HETATM;
	  sscanf(CarLin -> Line + 55, FormStr, ResSeq, Atm -> Pot.C, &Atm -> Charge);
          Str2Qchar(&Atm -> ResSeq, ResSeq);
        } else break;
      }
    }
    if (Atm) {
      Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
      LastAtm       = Atm;
    }
  }

  return InizAtm;
}


/**** Biosym Saver ****/

VG_BOOL CarSave(FILE *OUT, register ATOMO *Atm, VG_WORD SubFormat)
{
  char      DataStr[26];

  VG_BOOL   Ret   = TRUE;
  VG_ULONG  Count = 1;
  time_t    Data  = time(NULL);

  strcpy(DataStr, ctime(&Data));
  DataStr[24] = 0;

  /**** Write the header ****/

  if (fprintf(OUT, "!BIOSYM archive %d%63s\n" \
                   "%-80s\n" \
                   "%-80s\n" \
                   "!DATE %-74s\n",
                   SubFormat, " ", "PBC=OFF", VEGAHdr, DataStr) >= 0) {
    do {
      switch(SubFormat) {
      case 1:
        if (fprintf(OUT, "%-5.4s%15.9f%15.9f%15.9f %-5.4s%4.4s %-4.4s%9.4f%6d\n",
                         Atm -> Name.C, Atm -> x, Atm -> y, Atm -> z, Atm -> ResName.C,
                         Atm -> ResSeq.C, Atm -> Pot.C, Atm -> Charge, Count) < 0)
          Ret = PrintDosErr();
        break;
      case 3:
        if (fprintf(OUT, "%-5.4s%15.9f%15.9f%15.9f %-5.4s%-7.4s%-8.4s%-2.2s%7.3f\n",
                         Atm -> Name.C, Atm -> x, Atm -> y, Atm -> z, Atm -> ResName.C,
                         Atm -> ResSeq.C, Atm -> Pot.C, Atm -> Elem.C, Atm -> Charge) < 0)
          Ret = PrintDosErr();
        break;
      }
      if ((Ret) && (Atm -> Flags & VG_ATMF_SEGEND) && (fprintf(OUT, "end\n") < 0))
        Ret = PrintDosErr();
      Atm = Atm -> Ptr;
      ++Count;
    } while((Ret) && (Atm));
    if ((Ret) && (fprintf(OUT, "end\n") < 0))
      Ret = PrintDosErr();
  } else Ret = PrintDosErr();

  return Ret;
}
