
/*************************************************
****      VEGA - CHARMm loader & saver        ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"


/**** CRD Loader ****/

ATOMO *CRDLoad(FILE *IN, RECORD *Lin, VG_ULONG *TotAtomi)
{
  char               ResName[20], ResSeq[20];

  register ATOMO     *Atm       = NULL;
  ATOMO              *InizAtm   = NULL;

  while((*Lin -> Line == '*') && (fgets(Lin -> Line, LINELEN, IN)));
  if (!ferror(IN)) {
    while (fgets(Lin -> Line, LINELEN, IN)) {
      if (*Lin -> Line != '\n') {
        if ((Atm = AllocAtm(&InizAtm, TotAtomi)) != NULL) {
          sscanf(Lin -> Line, "%*s %s %s %4s %f %f %f",
                 ResSeq, ResName, Atm -> Name.C,
                 &Atm -> x, &Atm -> y, &Atm -> z);
          Str2Qchar(&Atm -> ResSeq , ResSeq);
          Str2Qchar(&Atm -> ResName, ResName);
          Atm -> Elem.C[0] = toupper(Atm -> Name.C[0]);
          if ((Atm -> Name.C[1]) && (islower(Atm -> Name.C[1])))
            Atm -> Elem.C[1] = Atm -> Name.C[1];
          if ((Atm -> ResName.L == *(VG_LONG *)"HOH") ||
              (Atm -> ResName.L == *(VG_LONG *)"TIP"))
            Atm -> Flags = VG_ATMF_HETATM;
        }
      }
    }
    if (Atm) {
      Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
      LastAtm       = Atm;
    }
  }

  return InizAtm;
}


/**** CHARMm CRD saver ****/

VG_BOOL CRDSave(FILE *OUT, ATOMO *InizAtm, VG_ULONG TotAtm)
{
  register ATOMO     *Atm;

  VG_BOOL             Ret   = TRUE;
  register VG_ULONG   Count = 1;

  if (fprintf(OUT, "* %s\n*\n%5d\n", VEGAHdr, TotAtm) > 0) {
    for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
      if (fprintf(OUT, "%5d %4.4s %-4.4s %-4.4s %9.5f %9.5f %9.5f %-4.4s %-4.4s %9.5f\n",
                  Count, Atm -> ResSeq.C, Atm -> ResName.C, Atm -> Name.C, Atm -> x, Atm -> y,
                  Atm -> z, Atm -> ResName.C, Atm -> ResSeq.C, Atm -> Charge) <= 0) {
        Ret = PrintDosErr();
        break;
      }
      ++Count;
    }
  } else Ret = PrintDosErr();


  return Ret;
}

