
/*************************************************
****          VEGA - Command parser           ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifndef __COMPAR_H
#define __COMPAR_H

#ifndef __COMERR_H
#  include "comerr.h"
#endif

/**** Get variables ****/

enum {
  VG_GETVAR_ERRCODE, /* Don't change the position of these two items ! */
  VG_GETVAR_ERRSTR,

  VG_GETVAR_CPUFEATURES,
  VG_GETVAR_CPUNAME,
  VG_GETVAR_CPUS,
  VG_GETVAR_CPUTYPE,
  VG_GETVAR_CPUVENDOR,
  VG_GETVAR_CURDIR,
  VG_GETVAR_CURLANG,
  VG_GETVAR_DATADIR,
  VG_GETVAR_OS,
  VG_GETVAR_OSFAMILY,
  VG_GETVAR_PRFLANG,
  VG_GETVAR_TMPDIR,
  VG_GETVAR_TMPFILE,
  VG_GETVAR_TOTATM,
  VG_GETVAR_TRJBESTENERGY,
  VG_GETVAR_TRJBESTFRM,
  VG_GETVAR_TRJCURFRM,
  VG_GETVAR_TRJSIMTIME,
  VG_GETVAR_TRJSTARTTIME,
  VG_GETVAR_TRJTEMP,
  VG_GETVAR_TRJTIMESTEP,
  VG_GETVAR_TRJTOTFRM,
  VG_GETVAR_TRJWORSEENERGY,
  VG_GETVAR_TRJWORSEFRM,
  VG_GETVAR_VEGADIR,
  VG_GETVAR_VERSION,

#ifdef __VG_OPENGL
  VG_GETVAR_CONBUFSIZE, VG_GETVAR_CONHISTSIZE, VG_GETVAR_CONPOSX,
  VG_GETVAR_CONPOSY, VG_GETVAR_CONSIZEX, VG_GETVAR_CONSIZEY, VG_GETVAR_CONVIS,
  VG_GETVAR_GLRENDERER, VG_GETVAR_GLVENDOR, VG_GETVAR_GLVERSION,
  VG_GETVAR_GLASSWIN,
  VG_GETVAR_GRAPHLABELX, VG_GETVAR_GRAPHLABELY, VG_GETVAR_GRAPHPOINTS, VG_GETVAR_GRAPHPOSX,
  VG_GETVAR_GRAPHPOSY, VG_GETVAR_GRAPHSIZEX, VG_GETVAR_GRAPHSIZEY, VG_GETVAR_GRAPHTITLE, VG_GETVAR_GRAPHVIS,
  VG_GETVAR_ISRUNNING,
  VG_GETVAR_MAINPOSX, VG_GETVAR_MAINPOSY, VG_GETVAR_MAINSIZEX, VG_GETVAR_MAINSIZEY,
  VG_GETVAR_PORTNUM,
  VG_GETVAR_SCREENDEPTH, VG_GETVAR_SCREENX, VG_GETVAR_SCREENY,
  VG_GETVAR_SCALE,
  VG_GETVAR_TRANSX, VG_GETVAR_TRANSY, VG_GETVAR_TRANSZ
#endif
};

/**** Standard command codes ****/

enum {
  VG_PARCOM_NOTHING   =  0,      /* Nothing                               */
  VG_PARCOM_CHARGE,              /* Assign the atom charges               */
  VG_PARCOM_ERRMSG,              /* Get error message                     */
  VG_PARCOM_FORCEFIELD,          /* Assign the atom types                 */
  VG_PARCOM_GET,                 /* Get a value                           */
  VG_PARCOM_LOGOFF,              /* Logoff the user                       */
  VG_PARCOM_MSGERRMODE,          /* Message error mode                    */
  VG_PARCOM_NEW,                 /* New                                   */
  VG_PARCOM_OPENMOL,             /* Open a molecule                       */
  VG_PARCOM_SAVEMOL,             /* Save a molecule                       */
  VG_PARCOM_SHUTDOWN,            /* Shutdown the system                   */
  VG_PARCOM_SRFCALC,             /* Calculate the molecular surface       */
  VG_PARCOM_SRFSAVE,             /* Save the molecular surface            */
  VG_PARCOM_TRJANIMPLAY,         /* Trajectory animation start            */
  VG_PARCOM_TRJANIMSET,          /* Trajectory animation settings         */
  VG_PARCOM_TRJANIMSPEED,        /* Trajectory animation speed            */
  VG_PARCOM_TRJANIMSTOP,         /* Trajectory animation stop             */
  VG_PARCOM_TRJOPEN,             /* Open a trajectory file                */
  VG_PARCOM_TRJSEL,              /* Select a specified frame              */
  VG_PARCOM_TRJSELFIRST,         /* Select the first frame                */
  VG_PARCOM_TRJSELLAST,          /* Select the last frame                 */
};


/**** OpenGL command codes ****/

#ifdef __VG_OPENGL
enum {
  VG_PARCOM_ANTIALIAS = 101,     /* Anti aliasing                         */
  VG_PARCOM_BIODOCK,             /* Run Biodock                           */
  VG_PARCOM_CHDIR,               /* Change the current directory          */
  VG_PARCOM_CLIPCOPY,            /* Copy data into the clipboard          */
  VG_PARCOM_COLOR,               /* Set the color drawing                 */
  VG_PARCOM_COLORIDDLG,          /* Color ID table                        */
  VG_PARCOM_COLORRGBDLG,         /* RGB Color table                       */
  VG_PARCOM_CONCLRHIST,          /* Clear the history buffer              */
  VG_PARCOM_CONCLS,              /* Clear the console buffer              */
  VG_PARCOM_CONSAVE,             /* Save the console buffer               */
  VG_PARCOM_CONSET,              /* Set the console parameters            */
  VG_PARCOM_CONWIN,              /* Console window position and size      */
  VG_PARCOM_CPKPROP,             /* CPK properties                        */
  VG_PARCOM_DIRDLG,              /* Directory dialog box                  */
  VG_PARCOM_DEPTHCUE,            /* Depth cue                             */
  VG_PARCOM_GRAPHADD,            /* Add one item in the graph             */
  VG_PARCOM_GRAPHCALC,           /* Calculate a graph property            */
  VG_PARCOM_GRAPHCLOSE,          /* Close the the graph window            */
  VG_PARCOM_GRAPHDELETE,         /* Delete an item                        */
  VG_PARCOM_GRAPHGET,            /* Get the item value                    */
  VG_PARCOM_GRAPHLABELX,         /* X axis label                          */
  VG_PARCOM_GRAPHLOAD,           /* Load the data into the chart          */
  VG_PARCOM_GRAPHLABELY,         /* Y axis label                          */
  VG_PARCOM_GRAPHNEW,            /* Clear all data in the graph           */
  VG_PARCOM_GRAPHOPEN,           /* Open the the graph window             */
  VG_PARCOM_GRAPHSAVE,           /* Save the graph data                   */
  VG_PARCOM_GRAPHSET,            /* Set the item value                    */
  VG_PARCOM_GRAPHTITLE,          /* Graphic title                         */
  VG_PARCOM_GRAPHWIN,            /* Graph window position and size        */
  VG_PARCOM_LIQPROP,             /* Liquorice properties                  */
  VG_PARCOM_MAINWIN,             /* Main window position and size         */
  VG_PARCOM_MESSAGEBOX,          /* Message box                           */
  VG_PARCOM_MINIED,              /* Open the Mini Editor                  */
  VG_PARCOM_MONITORPOWER,        /* Change the monitor power status       */
  VG_PARCOM_MOPAC,               /* Start the Mopac calculation           */
  VG_PARCOM_MULTISELDLG,         /* Multi selection dialog box            */
  VG_PARCOM_OPENDLG,             /* Open file dialog                      */
  VG_PARCOM_PLUGCALL,            /* Plugin: start the plugin              */
  VG_PARCOM_PLUGABOUT,           /* Plugin: open the about dialog         */
  VG_PARCOM_PLUGCONFIG,          /* Plugin: open the configuration dialog */
  VG_PARCOM_PLUGINGET,           /* Equivalent to Get, but faster         */
  VG_PARCOM_PLUGHELP,            /* Plugin: open the help dialog          */
  VG_PARCOM_REFRESH,             /* Refresh the OGL window                */
  VG_PARCOM_ROTATE,              /* Rotate                                */
  VG_PARCOM_SELECT,              /* Select atom(s)                        */
  VG_PARCOM_SAVEDLG,             /* Save file dialog                      */
  VG_PARCOM_SAVEIMG,             /* Save the current view as an image     */
  VG_PARCOM_SELRANGE,            /* Select range                          */
  VG_PARCOM_SMARTMOVE,           /* Enable/disable the smart move         */
  VG_PARCOM_SMARTMOVEATM,        /* Set the atom trashold for smart move  */
  VG_PARCOM_SONGPLAY,            /* Play a song                           */
  VG_PARCOM_SONGSTOP,            /* Stop song                             */
  VG_PARCOM_SONGVOL,             /* Song volume                           */
  VG_PARCOM_SRFCOLOR,            /* Change the surface color              */
  VG_PARCOM_SRFCOLORBY,          /* Change the surface by atom/property   */
  VG_PARCOM_STRINGBOX,           /* String box                            */
  VG_PARCOM_TEXT,                /* Print a text in the console window    */
  VG_PARCOM_TRANSLATE,           /* Translate                             */
  VG_PARCOM_UNSELECT,            /* Unselect atom(s)                      */
  VG_PARCOM_UNSELRANGE,          /* Unselect range                        */
  VG_PARCOM_VDWPROP,             /* Van der Waals properties              */
  VG_PARCOM_WIREPROP,            /* Wireframe properties                  */
  VG_PARCOM_ZCLIP,               /* Z-Clip value                          */
  VG_PARCOM_ZOOM                 /* Zoom                                  */
};
#endif

/**** Parameter types ****/

#define  VG_PARTYPE_UNK         0
#define  VG_PARTYPE_BOOL        1
#define  VG_PARTYPE_CHAR        2
#define  VG_PARTYPE_FLOAT       3
#define  VG_PARTYPE_INT         4
#define  VG_PARTYPE_UNSIGNED    8
#define  VG_PARTYPE_NOZERO     16
#define  VG_PARTYPE_MAX        32
#define  VG_PARTYPE_MIN        64
#define  VG_PARTYPE_CMTX      128

#define  VG_PARTYPE_MCHAR     (VG_PARTYPE_CHAR|VG_PARTYPE_CMTX)
#define  VG_PARTYPE_UFLOAT    (VG_PARTYPE_FLOAT|VG_PARTYPE_UNSIGNED)
#define  VG_PARTYPE_RUFLOAT   (VG_PARTYPE_FLOAT|VG_PARTYPE_UNSIGNED|VG_PARTYPE_MAX|VG_PARTYPE_MIN)
#define  VG_PARTYPE_UINT      (VG_PARTYPE_INT|VG_PARTYPE_UNSIGNED)
#define  VG_PARTYPE_RUINT     (VG_PARTYPE_INT|VG_PARTYPE_UNSIGNED|VG_PARTYPE_MAX|VG_PARTYPE_MIN)
#define  VG_PARTYPE_ZUINT     (VG_PARTYPE_INT|VG_PARTYPE_UNSIGNED|VG_PARTYPE_NOZERO)

/**** Command flags ****/

#define  VG_COMFLG_NOTHING      0       /* No special flags            */
#define  VG_COMFLG_OPENGL       1       /* OpenGL command              */
#define  VG_COMFLG_MOL          2       /* Molecule required           */
#define  VG_COMFLG_SRF          4       /* Surface required            */
#define  VG_COMFLG_TRJ          8       /* Trajectory required         */

#define  VG_COMFLG_MOGL         (VG_COMFLG_OPENGL|VG_COMFLG_MOL)
#define  VG_COMFLG_SOGL         (VG_COMFLG_OPENGL|VG_COMFLG_SRF)

/**** Structures ****/

typedef union {
  VG_LONG               L;
  VG_ULONG              UL;
  float                 F;
  char                  *C;
  VG_BOOL               B;
} VG_MULTI;

/**** Parameter (see command structure) ****/

typedef struct __VG_PARAM {
  struct __VG_PARAM     *Ptr;
  VG_UBYTE              Type;
  VG_MULTI              Data;
} VG_PARAM;

/**** Command structure ****/

typedef struct __VG_COMM {
  struct __VG_COMM      *Ptr;
  VG_UWORD              Id;
  VG_UBYTE              NumPar;
  VG_UBYTE              RetVal;
  VG_PARAM              *ParList;
} VG_COMM;

/**** Argument infos ****/

typedef struct {
  VG_UBYTE              ArgType;        /* Argument type       */
  VG_MULTI              Min;            /* Min value           */
  VG_MULTI              Max;            /* Max value           */
} VG_ARG_INFO;

/**** Commans infos ****/

typedef struct {
  VG_UWORD              Id;             /* Command ID                         */
  VG_UWORD              Flags;          /* Flags                              */
  VG_UWORD              NumArgs;        /* Number of arguments                */
  VG_BOOL               RetVal;         /* TRUE if the command return a value */
  char                  *Name;          /* Command Name                       */
  VG_ARG_INFO           *ArgTypes;      /* Argument types                     */
} VG_COMM_INFO;


/**** Command table ****/

#ifdef __COMPAR

/**** Generic templates ****/

static const VG_ARG_INFO VgInf_Bool1          =  {VG_PARTYPE_BOOL   , 0, 0};
static const VG_ARG_INFO VgInf_Char1          =  {VG_PARTYPE_CHAR   , 0, 0};
static const VG_ARG_INFO VgInf_Char2[]        = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0}};
static const VG_ARG_INFO VgInf_Char3[]        = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0}};
static const VG_ARG_INFO VgInf_Float2[]       = {{VG_PARTYPE_FLOAT  , 0, 0},
                                                 {VG_PARTYPE_FLOAT  , 0, 0}};
static const VG_ARG_INFO VgInf_Float3[]       = {{VG_PARTYPE_FLOAT  , 0, 0},
                                                 {VG_PARTYPE_FLOAT  , 0, 0},
                                                 {VG_PARTYPE_FLOAT  , 0, 0}};
static const VG_ARG_INFO VgInf_Uint1          =  {VG_PARTYPE_UINT   , 0, 0};
static const VG_ARG_INFO VgInf_Zuint1         =  {VG_PARTYPE_ZUINT  , 0, 0};

/**** Specific templates ****/

static const VG_ARG_INFO VgInf_FField[]       = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_BOOL   , 0, 0}};
static const VG_ARG_INFO VgInf_Get            = {VG_PARTYPE_MCHAR   , 0, (VG_ULONG) \
                                                 "ERRCODE\0ERRSTR\0" /* Don't change the position of these two items ! */
                                                 "CPUFEATURES\0CPUNAME\0CPUS\0CPUTYPE\0CPUVENDOR\0"
                                                 "CURDIR\0CURLANG\0DATADIR\0OS\0OSFAMILY\0"
                                                 "PRFLANG\0TMPDIR\0TMPFILE\0TOTATM\0"
                                                 "TRJBESTENERGY\0TRJBESTFRM\0TRJCURFRM\0TRJSIMTIME\0TRJSTARTTIME\0"
                                                 "TRJTEMP\0TRJTIMESTEP\0TRJTOTFRM\0TRJWORSEENERGY\0TRJWORSEFRM\0"
                                                 "VEGADIR\0VERSION\0"
#ifdef __VG_OPENGL
                                                 "CONBUFSIZE\0CONHISTSIZE\0CONPOSX\0CONPOSY\0CONSIZEX\0"
                                                 "CONSIZEY\0CONVISIBLE\0"
                                                 "GLRENDERER\0GLVENDOR\0GLVERSION\0"
                                                 "GLASSWIN\0"
                                                 "GRAPHLABELX\0GRAPHLABELY\0GRAPHPOINTS\0GRAPHPOSX\0GRAPHPOSY\0"
                                                 "GRAPHSIZEX\0GRAPHSIZEY\0GRAPHTITLE\0GRAPHVISIBLE\0"
                                                 "ISRUNNING\0"
                                                 "MAINPOSX\0MAINPOSY\0MAINSIZEX\0MAINSIZEY\0"
                                                 "PORTNUM\0"
                                                 "SCREENDEPTH\0SCREENX\0SCREENY\0"
                                                 "SCALE\0TRANSX\0TRANSY\0TRANSZ\0"
#endif
                                                };
static const VG_ARG_INFO VgInf_Color          =  {VG_PARTYPE_RUINT  , 0, (VG_ULONG)0xffffff};
static const VG_ARG_INFO VgInf_MsgErrMode     =  {VG_PARTYPE_MCHAR  , 0, (VG_ULONG)"CONSOLE\0WINDOW\0QUIET\0"};
static const VG_ARG_INFO VgInf_SaveMol[]      = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_BOOL   , 0, 0}};
static const VG_ARG_INFO VgInf_SrfCalc[]      = {{VG_PARTYPE_MCHAR  , 0, (VG_ULONG)"VDW\0MEP\0MLP\0ILM\0PSA\0"},
                                                 {VG_PARTYPE_UFLOAT , 0, 0},
                                                 {VG_PARTYPE_ZUINT  , 0, 0},
                                                 {VG_PARTYPE_BOOL   , 0, 0}};
static const VG_ARG_INFO VgInf_SrfSave[]      = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_MCHAR  , 0, (VG_ULONG)"QUANTA\0CSV\0IFF\0INSIGHT\0RAW\0"
                                                                                   "VRMLDOTTED\0VRMLSOLID\0"},
                                                 {VG_PARTYPE_CHAR   , 0, 0}};
static const VG_ARG_INFO VgInf_TrjAnimSet[]   = {{VG_PARTYPE_UINT   , 0, 0},
                                                 {VG_PARTYPE_UINT   , 0, 0},
                                                 {VG_PARTYPE_BOOL   , 0, 0}};
static const VG_ARG_INFO VgInf_TrjAnimSpeed[] = {{VG_PARTYPE_RUINT  , (VG_ULONG)0 , (VG_ULONG)500},
                                                 {VG_PARTYPE_UINT   , 0, 0}};
static const VG_ARG_INFO VgInf_TrjOpen[]      = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_BOOL   , 0, 0}};

/**** OpenGL Specific templates ****/

#ifdef __VG_OPENGL
static const VG_ARG_INFO VgInf_ConSet[]       = {{VG_PARTYPE_RUINT  , 20, (VG_ULONG)0xffffffff},
                                                 {VG_PARTYPE_ZUINT  , 0, 0}};
static const VG_ARG_INFO VgInf_Copy           = {VG_PARTYPE_MCHAR   , 0, (VG_ULONG)"VEGA\0BITMAP\0" \
                                                 "BIOSYM\0MOL2\0MOPAC\0PDB\0PDBF\0XYZ\0"};
static const VG_ARG_INFO VgInf_CpkProp[]      = {{VG_PARTYPE_RUINT  , (VG_ULONG)8 , (VG_ULONG)24},
                                                 {VG_PARTYPE_RUINT  , (VG_ULONG)10, (VG_ULONG)50},
                                                 {VG_PARTYPE_RUINT  , (VG_ULONG)5 , (VG_ULONG)20},
                                                 {VG_PARTYPE_RUFLOAT, 0x3d4ccccd  , 0x3f000000  }};
static const VG_ARG_INFO VgInf_GraphCalc      = {VG_PARTYPE_MCHAR   , 0, (VG_ULONG)"AVERAGEVAL\0MAXVAL\0" \
                                                 "MINVAL\0STDDEV\0"};
static const VG_ARG_INFO VgInf_GraphSave[]    = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_MCHAR  , 0, (VG_ULONG)"CSV\0PLT\0RAW\0"},
                                                 {VG_PARTYPE_CHAR   , 0, 0}};
static const VG_ARG_INFO VgInf_GraphSet[]     = {{VG_PARTYPE_UINT   , 0, 0},
                                                 {VG_PARTYPE_FLOAT  , 0, 0},
                                                 {VG_PARTYPE_FLOAT  , 0, 0}};
static const VG_ARG_INFO VgInf_LiqProp[]      = {{VG_PARTYPE_RUINT  , (VG_ULONG)8 , (VG_ULONG)24},
                                                 {VG_PARTYPE_RUINT  , (VG_ULONG)5 , (VG_ULONG)20},
                                                 {VG_PARTYPE_RUFLOAT, 0x3d4ccccd  , 0x3f000000  }};
static const VG_ARG_INFO VgInf_MessageBox[]   = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_INT    , 0, 0}};
static const VG_ARG_INFO VgInf_MiniEd[]       = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_INT    , 0, 0}};
static const VG_ARG_INFO VgInf_MultiSelDlg[]  = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_INT    , 0, 0}};
static const VG_ARG_INFO VgInf_OpenDlg[]      = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_ZUINT  , 0, 0}};
static const VG_ARG_INFO VgInf_PlgCall[]      = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_RUINT  , (VG_ULONG)1, (VG_ULONG)100}};
static const VG_ARG_INFO VgInf_SelRange[]     = {{VG_PARTYPE_MCHAR  , 0, (VG_ULONG)"ATOM\0RESIDUE\0"},
                                                 {VG_PARTYPE_ZUINT  , 0, 0},
                                                 {VG_PARTYPE_ZUINT  , 0, 0}};
static const VG_ARG_INFO VgInf_SongPlay[]     = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_UINT   , 0, 0}};
static const VG_ARG_INFO VgInf_SongVol        =  {VG_PARTYPE_RUINT  , (VG_ULONG)0, (VG_ULONG)255};
static const VG_ARG_INFO VgInf_SrfColorBy     =  {VG_PARTYPE_MCHAR  , 0, (VG_ULONG)"ATOM\0PROPERTY\0"};
static const VG_ARG_INFO VgInf_Text[]         = {{VG_PARTYPE_CHAR   , 0, 0},
                                                 {VG_PARTYPE_BOOL   , 0, 0}};
static const VG_ARG_INFO VgInf_VdwProp[]      = {{VG_PARTYPE_RUINT  , (VG_ULONG)8, (VG_ULONG)24},
                                                 {VG_PARTYPE_RUINT  , (VG_ULONG)1, (VG_ULONG)4}};
static const VG_ARG_INFO VgInf_Window[]       = {{VG_PARTYPE_UINT   , 0, 0},
                                                 {VG_PARTYPE_UINT   , 0, 0},
                                                 {VG_PARTYPE_ZUINT  , 0, 0},
                                                 {VG_PARTYPE_ZUINT  , 0, 0}};
static const VG_ARG_INFO VgInf_WireProp[]     = {{VG_PARTYPE_RUINT  , (VG_ULONG)1, (VG_ULONG)5},
                                                 {VG_PARTYPE_BOOL   , 0, 0}};
static const VG_ARG_INFO VgInf_Zclip          =  {VG_PARTYPE_RUINT  , (VG_ULONG)1, (VG_ULONG)300};
static const VG_ARG_INFO VgInf_Zoom           =  {VG_PARTYPE_UFLOAT , 0, 0};
#endif

/**** Command matrix ****/

static const VG_COMM_INFO    ComInfo[] = {
  {VG_PARCOM_CHARGE        , VG_COMFLG_MOL    , 1, FALSE, "CHARGE"       , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_CHDIR         , VG_COMFLG_NOTHING, 1, FALSE, "CHDIR"        , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_ERRMSG        , VG_COMFLG_NOTHING, 1, TRUE , "ERRMSG"       , (VG_ARG_INFO *)&VgInf_Zuint1       },
  {VG_PARCOM_FORCEFIELD    , VG_COMFLG_MOL    , 2, FALSE, "FORCEFIELD"   , (VG_ARG_INFO *)&VgInf_FField       },
  {VG_PARCOM_GET           , VG_COMFLG_NOTHING, 1, TRUE , "GET"          , (VG_ARG_INFO *)&VgInf_Get          },
  {VG_PARCOM_LOGOFF        , VG_COMFLG_NOTHING, 0, FALSE, "LOGOFF"       , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_MSGERRMODE    , VG_COMFLG_NOTHING, 1, FALSE, "MSGERRMODE"   , (VG_ARG_INFO *)&VgInf_MsgErrMode   },
  {VG_PARCOM_OPENMOL       , VG_COMFLG_NOTHING, 1, FALSE, "OPEN"         , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_NEW           , VG_COMFLG_NOTHING, 0, FALSE, "NEW"          , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_SAVEMOL       , VG_COMFLG_MOL    , 4, FALSE, "SAVE"         , (VG_ARG_INFO *)&VgInf_SaveMol      },
  {VG_PARCOM_SHUTDOWN      , VG_COMFLG_NOTHING, 0, FALSE, "SHUTDOWN"     , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_SRFCALC       , VG_COMFLG_MOL    , 4, TRUE , "SRFCALC"      , (VG_ARG_INFO *)&VgInf_SrfCalc      },
  {VG_PARCOM_SRFSAVE       , VG_COMFLG_SRF    , 3, FALSE, "SRFSAVE"      , (VG_ARG_INFO *)&VgInf_SrfSave      },
  {VG_PARCOM_TRJOPEN       , VG_COMFLG_NOTHING, 2, FALSE, "TRJOPEN"      , (VG_ARG_INFO *)&VgInf_TrjOpen      },
  {VG_PARCOM_TRJSEL        , VG_COMFLG_TRJ    , 1, FALSE, "TRJSEL"       , (VG_ARG_INFO *)&VgInf_Zuint1       },
  {VG_PARCOM_TRJSELFIRST   , VG_COMFLG_TRJ    , 0, FALSE, "TRJSELFIRST"  , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_TRJSELLAST    , VG_COMFLG_TRJ    , 0, FALSE, "TRJSELLAST"   , (VG_ARG_INFO *)NULL                },

#ifdef __VG_OPENGL
  {VG_PARCOM_ANTIALIAS     , VG_COMFLG_OPENGL , 1, FALSE, "ANTIALIAS"    , (VG_ARG_INFO *)&VgInf_Bool1        },
  {VG_PARCOM_BIODOCK       , VG_COMFLG_OPENGL , 1, FALSE, "BIODOCK"      , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_CLIPCOPY      , VG_COMFLG_MOGL   , 1, FALSE, "COPY"         , (VG_ARG_INFO *)&VgInf_Copy         },
  {VG_PARCOM_COLOR         , VG_COMFLG_MOGL   , 1, FALSE, "COLOR"        , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_COLORIDDLG    , VG_COMFLG_OPENGL , 1, TRUE , "COLORIDDLG"   , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_COLORRGBDLG   , VG_COMFLG_OPENGL , 0, TRUE , "COLORRGBDLG"  , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_CONCLRHIST    , VG_COMFLG_NOTHING, 0, FALSE, "CONCLRHIST"   , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_CONCLS        , VG_COMFLG_NOTHING, 0, FALSE, "CONCLS"       , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_CONSAVE       , VG_COMFLG_NOTHING, 1, FALSE, "CONSAVE"      , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_CONSET        , VG_COMFLG_NOTHING, 2, FALSE, "CONSET"       , (VG_ARG_INFO *)&VgInf_ConSet       },
  {VG_PARCOM_CONWIN        , VG_COMFLG_NOTHING, 4, FALSE, "CONWIN"       , (VG_ARG_INFO *)&VgInf_Window       },
  {VG_PARCOM_CPKPROP       , VG_COMFLG_OPENGL , 4, FALSE, "CPKPROP"      , (VG_ARG_INFO *)&VgInf_CpkProp      },
  {VG_PARCOM_DEPTHCUE      , VG_COMFLG_OPENGL , 1, FALSE, "DEPTHCUE"     , (VG_ARG_INFO *)&VgInf_Bool1        },
  {VG_PARCOM_DIRDLG        , VG_COMFLG_OPENGL , 2, TRUE , "DIRDLG"       , (VG_ARG_INFO *)&VgInf_Char2        },
  {VG_PARCOM_GRAPHADD      , VG_COMFLG_NOTHING, 2, FALSE, "GRAPHADD"     , (VG_ARG_INFO *)&VgInf_Float2       },
  {VG_PARCOM_GRAPHCALC     , VG_COMFLG_NOTHING, 1, TRUE , "GRAPHCALC"    , (VG_ARG_INFO *)&VgInf_GraphCalc    },
  {VG_PARCOM_GRAPHCLOSE    , VG_COMFLG_NOTHING, 0, FALSE, "GRAPHCLOSE"   , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_GRAPHDELETE   , VG_COMFLG_NOTHING, 1, FALSE, "GRAPHDELETE"  , (VG_ARG_INFO *)&VgInf_Uint1        },
  {VG_PARCOM_GRAPHGET      , VG_COMFLG_NOTHING, 1, TRUE , "GRAPHGET"     , (VG_ARG_INFO *)&VgInf_Uint1        },
  {VG_PARCOM_GRAPHLABELX   , VG_COMFLG_NOTHING, 1, FALSE, "GRAPHLABELX"  , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_GRAPHLABELY   , VG_COMFLG_NOTHING, 1, FALSE, "GRAPHLABELY"  , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_GRAPHLOAD     , VG_COMFLG_NOTHING, 1, FALSE, "GRAPHLOAD"    , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_GRAPHNEW      , VG_COMFLG_NOTHING, 0, FALSE, "GRAPHNEW"     , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_GRAPHOPEN     , VG_COMFLG_NOTHING, 1, FALSE, "GRAPHOPEN"    , (VG_ARG_INFO *)&VgInf_Uint1        },
  {VG_PARCOM_GRAPHSAVE     , VG_COMFLG_NOTHING, 3, FALSE, "GRAPHSAVE"    , (VG_ARG_INFO *)&VgInf_GraphSave    },
  {VG_PARCOM_GRAPHSET      , VG_COMFLG_NOTHING, 3, FALSE, "GRAPHSET"     , (VG_ARG_INFO *)&VgInf_GraphSet     },
  {VG_PARCOM_GRAPHTITLE    , VG_COMFLG_NOTHING, 1, FALSE, "GRAPHTITLE"   , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_GRAPHWIN      , VG_COMFLG_NOTHING, 4, FALSE, "GRAPHWIN"     , (VG_ARG_INFO *)&VgInf_Window       },
  {VG_PARCOM_LIQPROP       , VG_COMFLG_OPENGL , 3, FALSE, "LIQPROP"      , (VG_ARG_INFO *)&VgInf_LiqProp      },
  {VG_PARCOM_MAINWIN       , VG_COMFLG_NOTHING, 4, FALSE, "MAINWIN"      , (VG_ARG_INFO *)&VgInf_Window       },
  {VG_PARCOM_MESSAGEBOX    , VG_COMFLG_OPENGL , 3, TRUE , "MESSAGEBOX"   , (VG_ARG_INFO *)&VgInf_MessageBox   },
  {VG_PARCOM_MINIED        , VG_COMFLG_OPENGL , 3, FALSE, "MINIED"       , (VG_ARG_INFO *)&VgInf_MiniEd       },
  {VG_PARCOM_MONITORPOWER  , VG_COMFLG_OPENGL , 1, FALSE, "MONITORPOWER" , (VG_ARG_INFO *)&VgInf_Bool1        },
  {VG_PARCOM_MOPAC         , VG_COMFLG_MOGL   , 2, FALSE, "MOPAC"        , (VG_ARG_INFO *)&VgInf_Char2        },
  {VG_PARCOM_MULTISELDLG   , VG_COMFLG_OPENGL , 5, TRUE , "MULTISELDLG"  , (VG_ARG_INFO *)&VgInf_MultiSelDlg  },
  {VG_PARCOM_OPENDLG       , VG_COMFLG_OPENGL , 4, TRUE , "OPENDLG"      , (VG_ARG_INFO *)&VgInf_OpenDlg      },
  {VG_PARCOM_PLUGABOUT     , VG_COMFLG_OPENGL , 1, FALSE, "PLUGINABOUT"  , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_PLUGCALL      , VG_COMFLG_OPENGL , 2, FALSE, "PLUGINCALL"   , (VG_ARG_INFO *)&VgInf_PlgCall      },
  {VG_PARCOM_PLUGCONFIG    , VG_COMFLG_OPENGL , 1, FALSE, "PLUGINCONFIG" , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_PLUGINGET     , VG_COMFLG_NOTHING, 1, TRUE , "PLUGINGET"    , (VG_ARG_INFO *)&VgInf_Get          },
  {VG_PARCOM_PLUGHELP      , VG_COMFLG_OPENGL , 1, FALSE, "PLUGINHELP"   , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_REFRESH       , VG_COMFLG_OPENGL , 0, FALSE, "REFRESH"      , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_ROTATE        , VG_COMFLG_MOGL   , 3, FALSE, "ROTATE"       , (VG_ARG_INFO *)&VgInf_Float3       },
  {VG_PARCOM_SAVEDLG       , VG_COMFLG_OPENGL , 4, TRUE , "SAVEDLG"      , (VG_ARG_INFO *)&VgInf_OpenDlg      },
  {VG_PARCOM_SAVEIMG       , VG_COMFLG_MOGL   , 1, FALSE, "SAVEIMG"      , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_SELECT        , VG_COMFLG_MOGL   , 1, FALSE, "SELECT"       , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_SELRANGE      , VG_COMFLG_MOGL   , 3, FALSE, "SELRANGE"     , (VG_ARG_INFO *)&VgInf_SelRange     },
  {VG_PARCOM_SMARTMOVE     , VG_COMFLG_OPENGL , 1, FALSE, "SMARTMOVE"    , (VG_ARG_INFO *)&VgInf_Bool1        },
  {VG_PARCOM_SMARTMOVEATM  , VG_COMFLG_OPENGL , 1, FALSE, "SMARTMOVEATM" , (VG_ARG_INFO *)&VgInf_Uint1        },
  {VG_PARCOM_SONGPLAY      , VG_COMFLG_OPENGL , 2, FALSE, "SONGPLAY"     , (VG_ARG_INFO *)&VgInf_SongPlay     },
  {VG_PARCOM_SONGSTOP      , VG_COMFLG_OPENGL , 0, FALSE, "SONGSTOP"     , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_SONGVOL       , VG_COMFLG_OPENGL , 1, FALSE, "SONGVOL"      , (VG_ARG_INFO *)&VgInf_SongVol      },
  {VG_PARCOM_SRFCOLOR      , VG_COMFLG_SOGL   , 1, FALSE, "SRFCOLOR"     , (VG_ARG_INFO *)&VgInf_Color        },
  {VG_PARCOM_SRFCOLORBY    , VG_COMFLG_SOGL   , 1, FALSE, "SRFCOLORBY"   , (VG_ARG_INFO *)&VgInf_SrfColorBy   },
  {VG_PARCOM_STRINGBOX     , VG_COMFLG_OPENGL , 3, TRUE , "STRINGBOX"    , (VG_ARG_INFO *)&VgInf_Char3        },
  {VG_PARCOM_TEXT          , VG_COMFLG_OPENGL , 2, FALSE, "TEXT"         , (VG_ARG_INFO *)&VgInf_Text         },
  {VG_PARCOM_TRANSLATE     , VG_COMFLG_MOGL   , 3, FALSE, "TRANSLATE"    , (VG_ARG_INFO *)&VgInf_Float3       },
  {VG_PARCOM_TRJANIMPLAY   , VG_COMFLG_TRJ    , 0, FALSE, "TRJANIMPLAY"  , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_TRJANIMSET    , VG_COMFLG_TRJ    , 3, FALSE, "TRJANIMSET"   , (VG_ARG_INFO *)&VgInf_TrjAnimSet   },
  {VG_PARCOM_TRJANIMSPEED  , VG_COMFLG_TRJ    , 2, FALSE, "TRJANIMSPEED" , (VG_ARG_INFO *)&VgInf_TrjAnimSpeed },
  {VG_PARCOM_TRJANIMSTOP   , VG_COMFLG_TRJ    , 0, FALSE, "TRJANIMSTOP"  , (VG_ARG_INFO *)NULL                },
  {VG_PARCOM_UNSELECT      , VG_COMFLG_MOGL   , 1, FALSE, "UNSELECT"     , (VG_ARG_INFO *)&VgInf_Char1        },
  {VG_PARCOM_UNSELRANGE    , VG_COMFLG_MOGL   , 3, FALSE, "UNSELRANGE"   , (VG_ARG_INFO *)&VgInf_SelRange     },
  {VG_PARCOM_VDWPROP       , VG_COMFLG_OPENGL , 2, FALSE, "VDWPROP"      , (VG_ARG_INFO *)&VgInf_VdwProp      },
  {VG_PARCOM_WIREPROP      , VG_COMFLG_OPENGL , 2, FALSE, "WIREPROP"     , (VG_ARG_INFO *)&VgInf_WireProp     },
  {VG_PARCOM_ZCLIP         , VG_COMFLG_OPENGL , 1, FALSE, "ZCLIP"        , (VG_ARG_INFO *)&VgInf_Zclip        },
  {VG_PARCOM_ZOOM          , VG_COMFLG_MOGL   , 1, FALSE, "ZOOM"         , (VG_ARG_INFO *)&VgInf_Zoom         },
#endif

  {VG_PARCOM_NOTHING       , VG_COMFLG_NOTHING, 0, FALSE, NULL           , (VG_ARG_INFO *)NULL                }
};
#endif


/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_BOOL  ChkArgType(char *, VG_ULONG, VG_UBYTE);
void     ComExe(VG_COMM *);
VG_ULONG CountArgStr(char *);
char     *GetArgStr(char *, VG_ULONG *, char **);
void     FreeCom(VG_COMM *);
VG_COMM  *ParseStr(char *);

#  ifdef __cplusplus
}
#  endif
#endif

