
/*************************************************
****       VEGA - CSSR loader & saver         ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


/*
 * Supported CSSR subformats:
 * - CSSR    read & write
 * - QMC     read & write
 */

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"
#include "formats.h"


/**** CSSR Loader ****/

ATOMO *CSSRLoad(FILE *CSSRIN, RECORD *CSSRLin, VG_ULONG *TotAtomi, VG_UWORD SubForm)
{
  VG_UWORD          ChgOffset;

  register ATOMO    *Atm     = NULL;
  ATOMO             *InizAtm = NULL;

  if (SubForm) ChgOffset = 70;    /* QMC  */
  else ChgOffset = 74;            /* CSSR */
  do {
    if (*CSSRLin -> Line != '\n') {
      if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
        sscanf(CSSRLin -> Line, "%*s %4s %9f %9f %9f",
             Atm -> Name.C, &Atm -> x, &Atm -> y, &Atm -> z);
        sscanf(CSSRLin -> Line + ChgOffset, "%f", &Atm -> Charge);
        *Atm -> Elem.C = toupper(*Atm -> Name.C);
        if ((Atm -> Name.C[1]) && (islower(Atm -> Name.C[1])))
          Atm -> Elem.C[1] = Atm -> Name.C[1];
      } else break;
    }
  } while(fgets(CSSRLin -> Line, LINELEN, CSSRIN));
  if (Atm) {
    Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
    LastAtm       = Atm;
  }

  return InizAtm;
}

/**** CSSR Saver ****/

VG_BOOL CSSRSave(FILE *OUT, register ATOMO *Atm, VG_ULONG Tot, VG_UWORD Form)
{
  char            *Temp1, *Temp2, *Temp3;
  VG_ULONG           k, TotLeg;

  VG_BOOL            Ret   = TRUE;
  register VG_ULONG  Count = 1;

  if (Form) {
    Temp1  = "%4d %-5.4s %10.5f %10.5f %10.5f";
    Temp2  = "%5d";
    Temp3  = "    0";
    TotLeg = 4;
    if (fprintf(OUT, "%4d\n\n", Tot) < 0)
      Ret = PrintDosErr();
  } else {
    Temp1  = "%4d %-5.4s %9.5f %9.5f %9.5f";
    Temp2  = "%4d";
    Temp3  = "   0";
    TotLeg = MAXBOND;
    if (fprintf(OUT, " \n \n%4d   1 %s\n     0 %60s\n", Tot, VEGAHdr, " ") < 0)
      Ret = PrintDosErr();
  }

  if (Ret) {
    do {
      if (fprintf(OUT, Temp1, Count, Atm -> Name.C, Atm -> x, Atm -> y, Atm -> z) >= 0) {
        for(k = 0;(Ret) && (k < TotLeg);++k) {
          if (Atm -> Conn[k]) {
            if (fprintf(OUT, Temp2, Atm -> Conn[k] -> Num) < 0)
              Ret = PrintDosErr();
          } else if (fprintf(OUT, Temp3) < 0) Ret = PrintDosErr();
        }
        if (Ret) {
          if (Form) {
            if (fprintf(OUT, "    0   %8.5f\n", Atm -> Charge) < 0)
              Ret = PrintDosErr();
          } else if (fprintf(OUT, "   0   0%8.3f\n", Atm -> Charge) < 0)
            Ret = PrintDosErr();
          ++Count;
          Atm = Atm -> Ptr;
        }
      } else Ret = PrintDosErr();
    } while((Ret) && (Atm));
  }

  return Ret;
}
