
/*************************************************
****            VEGA - Fasta saver            ****
**** Copyright 1996-2001, Alessandro Pedretti ****
*************************************************/

/*
 * Save the primary residue sequence of a protein or nucleic acid in FASTA format.
 */

#include <stdio.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"

#define  TYPETOL	0.8


/**** FASTA saver ****/

VG_BOOL FastaSave(FILE *FH, ATOMO *InizAtm)
{
  char                  *AATab1;
  register ATOMO        *Atm;
  register VG_QCHAR     *AATab3;
  VG_UWORD              Type;

  VG_BOOL               Ret     = TRUE;
  VG_LONG               PrecNum = 0;
  VG_LONG               PrecRes = 0;
  VG_ULONG              TotRes  = 0;


  if ((Type = TypeOfMol(InizAtm)) != MOL_UNK) {
    if (fprintf(FH, "> %s\n", VEGAHdr) > 0) {
      for(Atm = InizAtm; (Atm -> Ptr) && (Ret); Atm = Atm -> Ptr)
        if ((PrecRes != Atm -> ResName.L) || (PrecNum != Atm -> ResSeq.L)) {
          PrecRes = Atm -> ResName.L;
          PrecNum = Atm -> ResSeq.L;
          switch(Type) {
          case MOL_PROT:
            AATab1 = AATab;
            for(AATab3 = AAResTab; *AATab3 -> C; ++AATab3) {
              if (AATab3 -> L == PrecRes) {
                if (fputc(*AATab1, FH) == *AATab1) ++TotRes;
                else Ret = PrintDosErr();
              }
              ++AATab1;
            }
            break;

          case MOL_NUCAC:
            if ((Atm -> ChainID == 'A') || (!Atm -> ChainID)) {
#ifdef LITTLE_ENDIAN
              if ((PrecRes == 0x41) || (PrecRes == 0x54) ||
                  (PrecRes == 0x43) || (PrecRes == 0x47) ||
                  (PrecRes == 0x55)) {
#else
              if ((PrecRes == 0x41000000) || (PrecRes == 0x54000000) ||
                  (PrecRes == 0x43000000) || (PrecRes == 0x47000000) ||
                  (PrecRes == 0x55000000)) {
#endif
                  if (fputc(*Atm -> ResName.C, FH) == *Atm -> ResName.C) ++TotRes;
                  else Ret = PrintDosErr();
              }
            }
            break;
          }
          if (TotRes) {
            if ((!(TotRes % 10)) && (fputc(' ', FH) != ' '))
              Ret = PrintDosErr();
            if ((!(TotRes % 70)) && (fputc('\n', FH) != '\n'))
              Ret = PrintDosErr();
          }
        }
      if ((TotRes) && (TotRes % 70) && (fputc('\n', FH) != '\n')) Ret = PrintDosErr();
    } else Ret = PrintDosErr();
  } else Ret = CatErr(MSG_ERR_FASTA_NOPROT);

  return Ret;
}


/**** Search the type of molecule ****/

VG_UWORD TypeOfMol(register ATOMO *Atm)
{
  register VG_UWORD k;

  register VG_LONG  PrecRes = 0;
  VG_ULONG          TotAA   = 0;
  VG_ULONG          TotNuc  = 0;
  VG_ULONG          TotRes  = 0;
  VG_UWORD          Type    = 0;

  while(Atm -> Ptr) {
    if (PrecRes != Atm -> ResName.L) {
      PrecRes = Atm -> ResName.L;
#ifdef LITTLE_ENDIAN
      if ((PrecRes == 0x41) || (PrecRes == 0x54) ||
          (PrecRes == 0x43) || (PrecRes == 0x47) ||
          (PrecRes == 0x55)) ++TotNuc;
#else
      if ((PrecRes == 0x41000000) || (PrecRes == 0x54000000) ||
          (PrecRes == 0x43000000) || (PrecRes == 0x47000000) ||
          (PrecRes == 0x55000000)) ++TotNuc;
#endif
      else {
        for(k = 0; k < 20; ++k)
          if (AAResTab[k].L == PrecRes) {
            ++TotAA;
            break;
          }
      }
      ++TotRes;
    }
    Atm = Atm -> Ptr;
  }
  TotRes *= TYPETOL;

  if ((TotAA) && (TotAA >= TotRes)) Type = MOL_PROT;
  else if ((TotNuc) && (TotNuc >= TotRes)) Type = MOL_NUCAC;

  return Type;
}
