
/*************************************************
****         VEGA - Format Definitions        ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifndef __FORMATS
#define  __FORMATS

/**** File format types ****/

#define  FORM_TYPE_MOLE      65536  /* Molecule                           */
#define  FORM_TYPE_SURF     131072  /* Surface                            */
#define  FORM_TYPE_PLOT     262144  /* Plot                               */
#define  FORM_TYPE_CALC     524288  /* Calculation                        */
#define  FORM_TYPE_FIELD   1048576  /* COMFA field                        */
#define  FORM_TYPE_SCREEN  2097152  /* Screen output                      */

/**** File formats ****/

#define  FORM_PDB               (  0 | FORM_TYPE_MOLE)
#define  FORM_PDB_NONSTD        (  1 | FORM_TYPE_MOLE)
#define  FORM_BIOSYM_OLD        (  2 | FORM_TYPE_MOLE)
#define  FORM_BIOSYM            (  3 | FORM_TYPE_MOLE)
#define  FORM_IFF               (  4 | FORM_TYPE_MOLE)
#define  FORM_CSSR              (  5 | FORM_TYPE_MOLE)
#define  FORM_MOPINT            (  6 | FORM_TYPE_MOLE)
#define  FORM_XYZ               (  7 | FORM_TYPE_MOLE)
#define  FORM_PDB_Q             (  8 | FORM_TYPE_MOLE)
#define  FORM_QUANTA_SRF        (  9 | FORM_TYPE_SURF)
#define  FORM_BIOSYM_SRF        ( 10 | FORM_TYPE_SURF)
#define  FORM_PDB_FAT           ( 11 | FORM_TYPE_MOLE)
#define  FORM_QMC               ( 12 | FORM_TYPE_MOLE)
#define  FORM_QUANTA_MSF        ( 13 | FORM_TYPE_MOLE)
#define  FORM_VRML_SRF_POINTS   ( 14 | FORM_TYPE_MOLE)
#define  FORM_VRML_SRF_CPK      ( 15 | FORM_TYPE_MOLE)
#define  FORM_VRML              ( 16 | FORM_TYPE_MOLE)
#define  FORM_VRML_SOLID        ( 17 | FORM_TYPE_MOLE)
#define  FORM_INFO              ( 18 | FORM_TYPE_CALC)
#define  FORM_FASTA             ( 19 | FORM_TYPE_MOLE)
#define  FORM_ENER_CVFF         ( 20 | FORM_TYPE_CALC)
#define  FORM_MOL2              ( 21 | FORM_TYPE_MOLE)
#define  FORM_CRD               ( 22 | FORM_TYPE_MOLE)
#define  FORM_GROMOS            ( 23 | FORM_TYPE_MOLE)
#define  FORM_QUANTA_LOGP       ( 24 | FORM_TYPE_SURF)
#define  FORM_QUANTA_MEP        ( 25 | FORM_TYPE_SURF)
#define  FORM_GROMOS_NM         ( 26 | FORM_TYPE_MOLE)
#define  FORM_PLOT_CSV          ( 27 | FORM_TYPE_PLOT)
#define  FORM_PLOT_QUANTA       ( 28 | FORM_TYPE_PLOT)
#define  FORM_PLOT_BIN          ( 29 | FORM_TYPE_PLOT)
#define  FORM_COMFAFLD          ( 30 | FORM_TYPE_FIELD)
#define  FORM_OPENGL            ( 31 | FORM_TYPE_SCREEN)
#define  FORM_QUANTA_ILM        ( 32 | FORM_TYPE_SURF)
#define  FORM_HIN               ( 33 | FORM_TYPE_MOLE)
#define  FORM_PDB_ATDL          ( 34 | FORM_TYPE_MOLE)
#define  FORM_MDL               ( 35 | FORM_TYPE_MOLE)
#define  FORM_GAMESS            ( 36 | FORM_TYPE_MOLE)
#define  FORM_ALCHEMY           ( 37 | FORM_TYPE_MOLE)
#define  FORM_CSV_SRF           ( 38 | FORM_TYPE_SURF)
#define  FORM_CSV_ILM           ( 39 | FORM_TYPE_SURF)
#define  FORM_CSV_LOGP          ( 40 | FORM_TYPE_SURF)
#define  FORM_CSV_MEP           ( 41 | FORM_TYPE_SURF)

/**** Trajectory formats ****/

#define  FTRJ_NONE               0
#define  FTRJ_BIODOCK            1
#define  FTRJ_DCD                2
#define  FTRJ_PDB                3
#define  FTRJ_XTC                4

/**** Plot data flags ****/

#define  FPLOT_FLG_TRAJ          256

/**** Plot data formats ****/

#define  FPLOT_UNK                0
#define  FPLOT_CHARMMENE         (1 | FPLOT_FLG_TRAJ)
#define  FPLOT_CSV                2
#define  FPLOT_GROMACSLOG        (3 | FPLOT_FLG_TRAJ)
#define  FPLOT_NAMDOUT           (4 | FPLOT_FLG_TRAJ)

/**** Surface output formats ****/

#define  SRF_QUANTA              0
#define  SRF_CSV                 1
#define  SRF_IFF                 2
#define  SRF_INSIGHT             3
#define  SRF_RAW                 4
#define  SRF_VRML_POINTS         5
#define  SRF_VRML_SOLID          6

/**** Surface properties ****/

#define  SRF_PROP_VDW        0x100
#define  SRF_PROP_VLOGP      0x200
#define  SRF_PROP_MEP        0x300
#define  SRF_PROP_ILM        0x400
#define  SRF_PROP_PSA        0x500

/**** Surface flags ****/

#define  SRF_FLG_ALLATM          0
#define  SRF_FLG_NOWAT           1
#define  SRF_FLG_SELONLY         2

/**** PDB subformats ****/

#define  PDB_PURE                0
#define  PDB_NONSTD              1
#define  PDB_PDBQ                2
#define  PDB_FAT                 3
#define  PDB_ATDL                4
#define  PDB_ORAC                5

/**** Biosym subformats ****/

#define  BIOSYM_OLD              1
#define  BIOSYM_NEW              3

/**** CSSR subformats ****/

#define  CSSR_PURE               0
#define  CSSR_QMC                1

/**** Selection types ****/

#define  SL_DISTANCE             0
#define  SL_ANGLE                1
#define  SL_TORSION              2
#define  SL_PLANEANG             3
#define  SL_MULTI                4
#define  SL_NONE                 5

/**** Type of mesure ****/

#define  MS_NONE                 0      /* Please don't chenge the order */
#define  MS_DISTANCE             1
#define  MS_ANGLE                2
#define  MS_TORSION              4
#define  MS_PLANEANG             8
#define  MS_VLOGP               16
#define  MS_DIPOLE              32
#define  MS_SURFACE             64
#define  MS_SURFDIA            128
#define  MS_VOLUME             256
#define  MS_VOLDIA             512
#define  MS_PSA               1024
#define  MS_ILM               2048

#define  MS_ALL                 MS_DISTANCE|MS_ANGLE|MS_TORSION|  \
                                MS_PLANEANG|MS_PLANEANG|MS_VLOGP| \
                                MS_DIPOLE|MS_SURFACE|MS_SURFACE|  \
                                MS_SURFDIA|MS_VOLUME|MS_VOLDIA|   \
                                MS_PSA|MS_ILM

/**** Control flags for file formats ****/

#define  FORM_FLAG_CONN         1  /* Allow the connectivity calculation */
#define  FORM_FLAG_CONNAL       2  /* The connectivity is needed         */
#define  FORM_FLAG_FFCALC       4  /* Allow the force field attribuition */
#define  FORM_FLAG_CHARGE       8  /* Allow atomic charges attribuition  */
#define  FORM_FLAG_STDOUT      16  /* Allow the stdout use               */
#define  FORM_FLAG_CHKCHG      32  /* Check the charges                  */
#define  FORM_FLAG_CHKFF       64  /* Check the force field              */
#define  FORM_FLAG_VDW        128  /* Assign VdW radii                   */
#define  FORM_FLAG_RINGS      256  /* Search for the rings               */

/**** Shape types for solvatation ****/

#define  SOL_SHAPE_BOX          0
#define  SOL_SHAPE_SPHERE       1
#define  SOL_SHAPE_LAYER        2


#ifdef __MAIN
FILEFORMAT FileInfo[] = {
/* PDB             */ { FORM_PDB            , "PDB"       , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN,
                        MS_NONE },
/* PDB Not Std.    */ { FORM_PDB_NONSTD     , "PDBNOTSTD" , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN,
                        MS_NONE },
/* Old Biosym      */ { FORM_BIOSYM_OLD     , "OLDBIOSYM" , "car" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE },
/* New Biosym      */ { FORM_BIOSYM         , "BIOSYM"    , "car" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE },
/* IFF             */ { FORM_IFF            , "IFF"       , "iff" ,
                        FORM_FLAG_CONN|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE },
/* CSSR            */ { FORM_CSSR           , "CSSR"      , "cssr",
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE },
/* Mopac Int.      */ { FORM_MOPINT         , "MOPINT"    , "dat" , FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_NONE },
/* Xyz             */ { FORM_XYZ            , "XYZ"       , "xyz" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE },
/* PDBQ            */ { FORM_PDB_Q          , "PDBQ"      , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE },
/* Quanta Surface  */ { FORM_QUANTA_SRF     , "QUANTASRF" , "srf" ,
                        0,
                        SRF_QUANTA|SRF_PROP_VDW },
/* Insight Surf.   */ { FORM_BIOSYM_SRF     , "BIOSYMSRF" , "srf" ,
                        FORM_FLAG_STDOUT,
                        SRF_INSIGHT|SRF_PROP_VDW },
/* PDB Fat         */ { FORM_PDB_FAT        , "PDBF"      , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE },
/* QMC             */ { FORM_QMC            , "QMC"       , "qmc" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE },
/* Quanta Msf      */ { FORM_QUANTA_MSF     , "MSF"       , "msf" ,
                        FORM_FLAG_CONN|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE },
/* VRML Dot Surf.  */ { FORM_VRML_SRF_POINTS, "VRMLPTS"   , "wrl" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_VDW,
                        MS_NONE },
/* VRML CPK        */ { FORM_VRML_SRF_CPK   , "VRMLCPK"   , "wrl" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE },
/* VRML wireframe  */ { FORM_VRML           , "VRML"      , "wrl" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL,
                        MS_NONE },
/* VRML Solid Srf  */ { FORM_VRML_SOLID     , "VRMLSOL"   , "wrl" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_VDW,
                        MS_NONE },
/* Informations    */ { FORM_INFO           , "INFO"      , "inf" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_RINGS,
                        MS_NONE },
/* Fasta           */ { FORM_FASTA          , "FASTA"     , "fas" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE },
/* Inter. Energy   */ { FORM_ENER_CVFF      , "CVFF"      , "ene" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE },
/* Sybyl Mol 2     */ { FORM_MOL2           , "MOL2"      , "ml2",
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        MS_NONE },
/* CHARMm CRD      */ { FORM_CRD            , "CRD"       , "CRD" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE },
/* Gromos          */ { FORM_GROMOS         , "GROMOS"    , "gro" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE },
/* Quanta LogP Srf */ { FORM_QUANTA_LOGP    , "QUANTALOGP", "srf" ,
                        FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_VDW|FORM_FLAG_RINGS,
                        MS_NONE },
/* Quanta Mep Srf  */ { FORM_QUANTA_MEP     , "QUANTAMEP" , "srf" ,
                        FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_VDW,
                        MS_NONE },
/* Gromos nm       */ { FORM_GROMOS_NM      , "GROMOSNM"  , "gro" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE },
/* CSV Plot        */ { FORM_PLOT_CSV       , "CSV"       , "csv" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_ALL },
/* Quanta Plot     */ { FORM_PLOT_QUANTA    , "QUANTAPLT" , "plt" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_ALL },
/* Binary Plot     */ { FORM_PLOT_BIN       , "BINPLT"    , "bin" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_ALL },
/* COMFA fld       */ { FORM_COMFAFLD       , "COMFAFLD"  , "fld" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_VLOGP },
/* OpenGL          */ { FORM_OPENGL         , "OPENGL"    , ""    ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_VDW, MS_NONE },
/* Quanta ILM Srf  */ { FORM_QUANTA_ILM     , "QUANTAILM" , "srf"  ,
                        FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_VDW|FORM_FLAG_RINGS,
                        MS_NONE },
/* HyperChem HIN   */ { FORM_HIN            , "HIN"      , "hin",
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE },
/* PDB ATDL        */ { FORM_PDB_ATDL       , "PDBA"     , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        MS_NONE },
/* MDL             */ { FORM_MDL            , "MDLMOL"   , "mdl" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        MS_NONE },
/* GAMESS          */ { FORM_GAMESS         , "GAMESS"   , "inp" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE },
/* ALCHEMY         */ { FORM_ALCHEMY        , "ALCHEMY"  , "alc" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        MS_NONE },
/* Csv Surface     */ { FORM_CSV_SRF        , "CSVSRF"   , "csv" ,
                        FORM_FLAG_STDOUT|SRF_CSV|SRF_PROP_VDW,
                        MS_NONE },
/* Csv ILM Srf     */ { FORM_CSV_ILM        , "CSVILM"   , "csv" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_VDW|FORM_FLAG_RINGS,
                        MS_NONE },
/* Csv LogP Srf    */ { FORM_CSV_LOGP       , "CSVLOGP"  , "csv" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_VDW|FORM_FLAG_RINGS,
                        MS_NONE },
/* Csv Mep Srf     */ { FORM_CSV_MEP        , "CSVMEP"   , "csv" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_VDW,
                        MS_NONE },
                      { 0                   , NULL        , NULL  , 0, 0}
};
#else
extern FILEFORMAT  FileInfo[];
#endif
#endif


