
/*************************************************
****       VEGA - GAMESS loader & saver       ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"

/**** GAMESS Cartesian Loader ****/

ATOMO *GamessLoad(FILE *IN, RECORD *Lin, VG_ULONG *TotAtomi)
{
  char                  Name[16];

  ATOMO			*InizAtm = NULL;
  register ATOMO        *Atm     = NULL;
  VG_ULONG              Line     = 0;

  while(fgets(Lin -> Line, LINELEN, IN)) {
    if ((InizAtm) && ((*Lin -> Line == 10) || (*Lin -> Line == 13)))
      break;
    if ((++Line > 2) && (*Lin -> Line != '$') &&
        (strchr(Lin -> Line, '.')) && (!strchr(Lin -> Line, '='))) {
      if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
        Name[2] = 0;
        sscanf(Lin -> Line, "%s %*s %f %f %f",
               Name, &Atm -> x, &Atm -> y, &Atm -> z);
        Atm -> Name.C[0] = Atm -> Elem.C[0] = (char)toupper(*Name);
        if ((Name[1]) && (!Name[2]))
            Atm -> Name.C[1] = Atm -> Elem.C[1] = (char)tolower(Name[1]);
      } else break;
    }
  } /* End of while */

  if (Atm) {
    Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
    LastAtm       = Atm;
  }

  return InizAtm;
}


/**** GAMESS Cartesian Saver ****/

VG_BOOL GamessSave(FILE *OUT, register ATOMO *Atm, char *FileName)
{
  VG_BOOL       Ret   = TRUE;

  if (fprintf(OUT, " $CONTRL COORD=CART UNITS=ANGS $END\n" \
                   " $DATA\n" \
                   "%s\n" \
                   "Put symmetry info here\n" \
                   "\n", GetFileName(FileName)) > 0) {
    while(Atm) {
      if (fprintf(OUT, "%-2.2s  %3d.0 %11.5f %11.5f %11.5f\n",
                  Atm -> Elem.C, GetAtmNum(Atm -> Elem.S),
                  Atm -> x, Atm -> y, Atm -> z) <= 0) {
        Ret = PrintDosErr();
        break;
      }
      Atm = Atm -> Ptr;
    } /* End of while */
    if ((Ret) && (fprintf(OUT, " $END\n") <= 0))
      Ret = PrintDosErr(); 
  } else Ret = PrintDosErr();

  return Ret;
}
