
/*************************************************
****     VEGA - Gasteiger-Marsilli Charges    ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "gasteiger.h"


VG_BOOL Gasteiger(char *Template, ATOMO *InizAtm, VG_ULONG TotAtm)
{
  char			Buf[256], *Ptr;
  FILE			*FH;
  float			*x, *xx;
  float			a, b, c, d, Charge;
  float			d1, d2, z1, q1;
  GASTPAR		*InizPar;
  VG_QCHAR		AtmType;
  register ATOMO        *Atm, *Atm2;
  register GASTPAR	*Gast;
  VG_UWORD		k;
  VG_ULONG		i, j, t;

  VG_BOOL		Chk   = TRUE;
  VG_BOOL		Ret   = FALSE;
  VG_ULONG		Ass   = 0;
  VG_UWORD		cycle = 0;

  if ((FH = (FILE *)fopen(Template, "r"))) {
    if ((InizPar = (GASTPAR *)Alloca(sizeof(GASTPAR) * TotAtm))) {
      if ((xx = (float *)Alloca(sizeof(float) * TotAtm))) {

       /**** Load Gasteiger parameters ****/

        while((Chk) && (fgets(Buf, 255, FH))) {
          if ((*Buf != '\n') && (*Buf != '#') && (*Buf != ';')) {
            k         = 0;
            AtmType.L = 0;
            for(Ptr = Buf; *Ptr; ++Ptr)
              if ((*Ptr != '\n') && (*Ptr != ' ') && (*Ptr != '\t')) {
                AtmType.C[k++] = *Ptr;
                if (k == 4) break;
              } else if (k) break;
            if (*Ptr) {
              sscanf(Buf, "%*s %f %f %f %*s %f", &a, &b, &c, &Charge);
              d = a + b + c;
              if (d == 0.0) d = 1.0;
              x    = xx;
              Gast = InizPar;
              for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
                if (Atm -> Pot.L == AtmType.L) {
                  Gast -> a      = a;
                  Gast -> b      = b;
                  Gast -> c      = c;
                  Gast -> d      = d;
                  Atm  -> Charge = Charge;
                  *x             = a;
                  ++Ass;
                  if (Ass == TotAtm) {
                    Chk = FALSE;
                    break;
                  }
                }
                ++Gast;
                ++x;
              } /* End of for */
            }
          }
        } /* End of while */

        /**** Smoothing charges ****/

        z1 = 1.0;
        do {
          z1  *= 0.5;
          d1   = 0.0;
          i    = 0;
          for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
            if (InizPar[i].d != 1.0) {
              q1 = Atm -> Charge;
              for (j = 0; j < (VG_ULONG)Atm -> NSost; j++) {
                t = (Atm -> Conn[j] -> Num) - 1;
                if (InizPar[t].d != 1.0) {
                  Atm2 = Atm -> Conn[j];
                  d2 = InizPar[t].d;
                  if (xx[t] > xx[i]) d2 = InizPar[i].d;
                  if (Atm -> Elem.S == *(VG_WORD *)"H")
                    d2 = 20.02;
                  if (Atm2 -> Elem.S == *(VG_WORD *)"H")
                    d2 = 20.02;
                  Atm -> Charge += (xx[t] - xx[i]) / d2 * z1;
                }
              }
              q1 = fabs(Atm -> Charge - q1);
              if (q1 > d1) d1 = q1;
            }
            ++i;
          } /* End of for */

          if (d1 >= 0.001) {
            Atm = InizAtm;
            for(i = 0; i < TotAtm; ++i) {
              xx[i] = InizPar[i].a + InizPar[i].b * Atm -> Charge +
                      InizPar[i].c * Quad(Atm -> Charge);
              Atm = Atm -> Ptr;
            }
          }
          cycle++;
        } while ((d1 > 0.001) && (cycle <= 5));
        Ret = TRUE;

        a = 0;
        for(Atm = InizAtm; Atm; Atm = Atm -> Ptr)
          a += Atm -> Charge;
        if (fabs(a) < 0.01) a = 0.0;
        if (!GLOBSW_STDOUT) CatPrintf(stdout, MSG_GASTEIGER_TOTCHG, a);
        FREE(xx);
      }
      FREE(InizPar);
    }
    fclose(FH);
  }

  return Ret;
}
