
/*************************************************
****                   VEGA                   ****
****     Color managment for OpenGL V1.0      ****
**** Copyright 1996-2001, Alessandro Pedretti ****
*************************************************/

#ifndef  __GL_COLORS_H
#  define  __GL_COLORS_H

/**** Macros ****/

#define GL_SetColor(ID) glColor3ubv(&ColorTable[(ID)].R)

/**** Structures ****/

typedef struct {
  char          *Name;          /* Pointer of color name    */
  VG_UBYTE      R, G, B;        /* RGB values               */
  VG_UBYTE      ID;             /* Color ID                 */
} VG_COLOR;

typedef struct {
  VG_DCHAR      Elem;           /* Element name             */
  VG_UBYTE      ColorID;        /* Color ID                 */
} VG_ATMCOL;

typedef struct {
  VG_QCHAR      ResName;        /* Residue name             */
  VG_UBYTE      ColorID;        /* Color ID                 */
} VG_RESCOL;


#ifdef __COLORTABLE
VG_COLOR ColorTable[] = { {"NONE"       ,   0,   0,   0, VGCOL_NONE       },
                          {"BLACK"      ,   0,   0,   0, VGCOL_BLACK      },
                          {"WHITE"      , 255, 255, 255, VGCOL_WHITE      },
                          {"RED"        , 255,   0,   0, VGCOL_RED        },
                          {"GREEN"      ,   0, 255,   0, VGCOL_GREEN      },
                          {"CYAN"       ,   0, 255, 255, VGCOL_CYAN       },
                          {"YELLOW"     , 255, 255,   0, VGCOL_YELLOW     },
                          {"FIREBIRCK"  , 178,  34,  32, VGCOL_FIREBIRCK  },
                          {"MAGENTA"    , 255,   0, 255, VGCOL_MAGENTA    },
                          {"PINK"       , 255, 153, 204, VGCOL_PINK       },
                          {"VIOLET"     , 153,   0, 153, VGCOL_VIOLET     },
                          {"GRAY"       , 200, 200, 200, VGCOL_GRAY       },
                          {"ORANGE"     , 255, 102,   0, VGCOL_ORANGE     },
                          {"DARKGREEN"  ,  34, 139,  34, VGCOL_DARKGREEN  },
                          {"BLUE"       ,   0,   0, 255, VGCOL_BLUE       },
                          {"DARKYELLOW" , 255, 200,  50, VGCOL_DARKYELLOW },
                          {"BROWN"      , 102,  51,  51, VGCOL_BROWN      },
                          {"SKYBLUE"    , 143, 143, 255, VGCOL_SKYBLUE    },

                          {"DARKGRAY"   , 102, 102, 102, VGCOL_DARKGRAY   },
                          {"GHOSTPINK"  , 255, 195, 204, VGCOL_GHOSTPINK  },
                          {"GHOSTGREEN" , 204, 255, 204, VGCOL_GHOSTGREEN },
                          {"GHOSTBLUE"  , 204, 255, 255, VGCOL_GHOSTBLUE  },
                          {"GHOSTYELLOW", 255, 255, 204, VGCOL_GHOSTYELLOW},
                          {"GHOSTGRAY"  , 229, 229, 229, VGCOL_GHOSTGRAY  },
                          {"SAND"       , 255, 204, 153, VGCOL_SAND       },

                          {NULL        ,   0,    0,  0, 255               }
                        };

VG_ATMCOL AtmColTbl[] = { {{'C',  0 }, VGCOL_GREEN   },
                          {{'H',  0 }, VGCOL_WHITE   },
                          {{'N',  0 }, VGCOL_BLUE    },
                          {{'O',  0 }, VGCOL_RED     },
                          {{'S',  0 }, VGCOL_YELLOW  },
                          {{'F',  0 }, VGCOL_CYAN    },
                          {{'C', 'l'}, VGCOL_MAGENTA },
                          {{'B', 'r'}, VGCOL_ORANGE  },
                          {{'I',  0 }, VGCOL_VIOLET  },
                          {{ 0 ,  0 }, VGCOL_MAGENTA }
                        };

VG_RESCOL ResColTab[] = { {{"ALA"  }, VGCOL_GRAY       },
                          {{"ARG"  }, VGCOL_RED        },
                          {{"ARG+" }, VGCOL_RED        },
                          {{"ASN"  }, VGCOL_MAGENTA    },
                          {{"ASP"  }, VGCOL_BLUE       },
                          {{"ASP-" }, VGCOL_BLUE       },
                          {{"CYS"  }, VGCOL_YELLOW     },
                          {{"CYH"  }, VGCOL_YELLOW     },
                          {{"GLU"  }, VGCOL_CYAN       },
                          {{"GLU-" }, VGCOL_CYAN       },
                          {{"GLN"  }, VGCOL_DARKGREEN  },
                          {{"GLY"  }, VGCOL_WHITE      },
                          {{"HIS"  }, VGCOL_BROWN      },
                          {{"HI+"  }, VGCOL_BROWN      },
                          {{"ILE"  }, VGCOL_MAGENTA    },
                          {{"LEU"  }, VGCOL_PINK       },
                          {{"LYS"  }, VGCOL_ORANGE     },
                          {{"LYS+" }, VGCOL_ORANGE     },
                          {{"MET"  }, VGCOL_DARKYELLOW },
                          {{"PHE"  }, VGCOL_FIREBIRCK  },
                          {{"PRO"  }, VGCOL_GHOSTBLUE  },
                          {{"SER"  }, VGCOL_SKYBLUE    },
                          {{"THR"  }, VGCOL_GHOSTPINK  },
                          {{"TRP"  }, VGCOL_GHOSTYELLOW},
                          {{"TYR"  }, VGCOL_SAND       },
                          {{"VAL"  }, VGCOL_GHOSTGREEN },

                          {{"A\0\0"}, VGCOL_BLUE       },
                          {{"T\0\0"}, VGCOL_CYAN       },
                          {{"C\0\0"}, VGCOL_YELLOW     },
                          {{"G\0\0"}, VGCOL_RED        },
                          {{"U\0\0"}, VGCOL_SKYBLUE    },

                          {{"HOH"  }, VGCOL_BLUE       },
                          {{"TIP3" }, VGCOL_BLUE       },
                          {{""     }, 0                }
                       };
#else
extern VG_COLOR   ColorTable[];
extern VG_ATMCOL  AtmColTbl[];
extern VG_UBYTE   AaColTab[];
#endif
#endif
