
/*************************************************
****    VEGA - Special FX for OpenGL Demo     ****
**** Copyright 1996-2001, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <gl\gl.h>
#include <gl\glu.h>
#include <gl\glaux.h>
#include <stdio.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "gl_global.h"
#include "gl_colors.h"

/**** Local variables ****/

static GLuint           texture[1];


/**** Local prototypes ****/

AUX_RGBImageRec *LoadBMP(char *);
VG_BOOL         LoadGLTextures(void);


/**** Loads A Bitmap Image ****/

AUX_RGBImageRec *LoadBMP(char *Filename)
{
  if (!FileExists(Filename)) {
    PrintDosErr();
    return NULL;
  } else return auxDIBImageLoad(Filename);
}


/**** Load Bitmaps And Convert To Textures ****/

VG_BOOL LoadGLTextures(void)
{
  AUX_RGBImageRec       *TextureImage[1];
  VG_BOOL               Status = FALSE;

  memset(TextureImage, 0, sizeof(void *)*1);           	// Set The Pointer To NULL

  if (TextureImage[0] = LoadBMP(GL_DemoGetPath("boxface.bmp"))) {
    Status = TRUE;
    glGenTextures(1, &texture[0]);
    glBindTexture(GL_TEXTURE_2D, texture[0]);
    glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[0]->sizeX, TextureImage[0]->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, TextureImage[0]->data);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  }

  if (TextureImage[0]) {
    if (TextureImage[0] -> data) {
      free(TextureImage[0] -> data);
    }
    free(TextureImage[0]);
  }

  return Status;
}

/**** Release resources ****/

void GL_DemoRelaseFX(void)
{
  glDeleteTextures(1, texture);
}


/**** Demo FX initialization ****/

VG_BOOL GL_DemoInitFX(void)
{
  if (!LoadGLTextures())
    return FALSE;

  return TRUE;
}


/**** Draw cube ****/

void GL_DemoDrawFX(void)
{
  glBindTexture(GL_TEXTURE_2D, texture[0]);

  glBegin(GL_QUADS);
    // Front Face
    glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
    glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
    glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
    glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
    // Back Face
    glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
    glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
    glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
    glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
    // Top Face
    glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
    glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
    glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
    glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
    // Bottom Face
    glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
    glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
    glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
    glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
    // Right face
    glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
    glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
    glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
    glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
    // Left Face
    glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
    glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
    glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
    glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
  glEnd();
  glBindTexture(GL_TEXTURE_2D, NULL);
}