
/*************************************************
****       VEGA - OpenGL Demo event list      ****
**** Copyright 1996-2001, Alessandro Pedretti ****
*************************************************/


//#include "gl_menu.h"

#define  TM_TITLE       150
#define  TM_COLOR       70

#define  SONG_FILE      "song.mp3"


/**** Demo event list ****/

GLDM_BEGIN

    /**** Titles ****/

  GLDM_LABEL(10)
    GLDM_CENTX(0.0)
    GLDM_CENTY(0.0)
    GLDM_CENTZ(-5.0)
    GLDM_ROTX(1.0)
    GLDM_VOLUME(255)
    GLDM_PLAYSONG(SONG_FILE)

    GLDM_FX(0)
    GLDM_IF(DMFL_NOTSUBTITLES, 20)
    GLDM_TEXT("VEGA " VEGA_VERSTR " OpenGL", TXT_LOWLEFT)
    GLDM_SLEEP(TM_TITLE)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(TM_TITLE)
    GLDM_TEXT("(c) " VEGA_COPYRIGHT ", Alessandro Pedretti & Giulio Vistoli", TXT_LOWLEFT)
    GLDM_SLEEP(TM_TITLE)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(TM_TITLE)
    GLDM_TEXT("\"Apidya Credits\", original music by Chris Huelsbeck", TXT_LOWLEFT)
    GLDM_SLEEP(TM_TITLE)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(TM_TITLE)
    GLDM_TEXT("Loading ...", TXT_LOWLEFT)
    GLDM_STEPZ(-1.5)
    GLDM_SLEEP(150)
    GLDM_STEPZ(0)
    GLDM_FX(0)

  GLDM_LABEL(20)

    /**** Estradiol ****/

    GLDM_NEW
    GLDM_TEXT("", 0)
    GLDM_LOAD("estra.pdb.bz2")
    GLDM_CENTX(0.0)
    GLDM_CENTY(0.0)
    GLDM_CENTZ(-200.0)
    GLDM_ROTY(10.0)
    GLDM_COLOR(VGCOL_RED)
    GLDM_DRAW(VG_GLDRAW_WIREFRAME)
    GLDM_TEXT("", 0)

    GLDM_STEPZ(3.1)
    GLDM_SLEEP(60)
    GLDM_STEPZ(0)
    GLDM_ROTY(1.0)
    GLDM_IF(DMFL_NOTSUBTITLES, 30)
    GLDM_TEXT("Estradiol", TXT_LOWLEFT)

  GLDM_LABEL(30)

    GLDM_SLEEP(200)
    GLDM_COLOR(VGCOL_GREEN)
    GLDM_SLEEP(100)
    GLDM_COLAT

    GLDM_SLEEP(300)
    GLDM_ROTX(0.5)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(500)
    GLDM_ATMLBL(VG_ATMLBL_ELEMENT)
    GLDM_IF(DMFL_NOTSUBTITLES, 35)
    GLDM_TEXT("Labels of elements", TXT_LOWLEFT)

  GLDM_LABEL(35)
    GLDM_SLEEP(500)
    GLDM_ATMLBL(VG_ATMLBL_NAME)
    GLDM_IF(DMFL_NOTSUBTITLES, 36)
    GLDM_TEXT("Labels of atom names", TXT_LOWLEFT)

  GLDM_LABEL(36)
    GLDM_SLEEP(500)
    GLDM_TEXT("", TXT_LOWLEFT)
    GLDM_ATMLBL(VG_ATMLBL_NONE)

    GLDM_STEPZ(-1.0)
    GLDM_SLEEP(150)
    GLDM_STEPZ(0)

    GLDM_DRAW(VG_GLDRAW_CPK_WIRE)

    GLDM_STEPZ(1.0)
    GLDM_SLEEP(150)
    GLDM_STEPZ(0)
    GLDM_IF(DMFL_NOTSUBTITLES, 40)
    GLDM_TEXT("CPK Wireframe", TXT_LOWLEFT)

  GLDM_LABEL(40)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(800)
    GLDM_DRAW(VG_GLDRAW_CPK_SOLID)
    GLDM_IF(DMFL_NOTSUBTITLES, 50)
    GLDM_TEXT("CPK Solid", TXT_LOWLEFT)

  GLDM_LABEL(50)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(800)
    GLDM_STEPZ(-1.0)
    GLDM_SLEEP(150)
    GLDM_STEPZ(0)

    GLDM_DRAW(VG_GLDRAW_LIQUORICE)
    GLDM_STEPZ(1.0)
    GLDM_SLEEP(150)
    GLDM_STEPZ(0)
    GLDM_IF(DMFL_NOTSUBTITLES, 55)
    GLDM_TEXT("Liquorice", TXT_LOWLEFT)

  GLDM_LABEL(55)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(800)
    GLDM_STEPZ(-1.0)
    GLDM_SLEEP(200)
    GLDM_STEPZ(0)

    /**** ASA ****/

    GLDM_NEW
    GLDM_LOAD("asa.pdb.bz2")
    GLDM_CENTX(0.0)
    GLDM_CENTY(0.0)
    GLDM_CENTZ(-200.0)
    GLDM_ROTX(0.5)
    GLDM_ROTY(1.0)
    GLDM_DRAW(VG_GLDRAW_WIREFRAME)
    GLDM_COLAT
    GLDM_STEPZ(1.0)
    GLDM_SLEEP(190)
    GLDM_STEPZ(0)
    GLDM_IF(DMFL_NOTSUBTITLES, 60)
    GLDM_TEXT("Acetyl salicidic acid (Aspirine)", TXT_LOWLEFT)

  GLDM_LABEL(60)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(700)

    GLDM_STEPZ(-1.0)
    GLDM_SLEEP(150)
    GLDM_STEPZ(0)

    GLDM_DRAW(VG_GLDRAW_VDW_DOTTED)
    GLDM_STEPZ(1.0)
    GLDM_SLEEP(145)
    GLDM_STEPZ(0)
    GLDM_IF(DMFL_NOTSUBTITLES, 70)
    GLDM_TEXT("VdW Dotted", TXT_LOWLEFT)
  GLDM_LABEL(70)
    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(800)

    GLDM_DRAW(VG_GLDRAW_VDW_WIRE)
    GLDM_IF(DMFL_NOTSUBTITLES, 80)
    GLDM_TEXT("VdW Wireframe", TXT_LOWLEFT)
  GLDM_LABEL(80)
    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(800)

    GLDM_DRAW(VG_GLDRAW_VDW_SOLID)
    GLDM_IF(DMFL_NOTSUBTITLES, 85)
    GLDM_TEXT("VdW Solid", TXT_LOWLEFT)
  GLDM_LABEL(85)
    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(800)

    GLDM_EXPLODE(1.5, 100)

    /**** Water Cluster ****/

    GLDM_NEW
    GLDM_LOAD("estra.pdb.bz2")
    GLDM_CENTX(0.0)
    GLDM_CENTY(0.0)
    GLDM_CENTZ(-200.0)
    GLDM_ROTX(0.5)
    GLDM_ROTY(1.0)
    GLDM_DRAW(VG_GLDRAW_WIREFRAME)
    GLDM_SOLVS(10.0)
    GLDM_COLAT
    GLDM_STEPZ(1.0)
    GLDM_SLEEP(170)
    GLDM_STEPZ(0)
    GLDM_IF(DMFL_NOTSUBTITLES, 90)
    GLDM_TEXT("Realtime water solvatation", TXT_LOWLEFT)

  GLDM_LABEL(90)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(1000)
    GLDM_STEPZ(-1.0)
    GLDM_SLEEP(200)
    GLDM_STEPZ(0)

    /**** Surface ****/

    GLDM_LOAD("cd61cl.pdb.bz2")
    GLDM_CENTX(0.0)
    GLDM_CENTY(0.0)
    GLDM_CENTZ(-200.0)
    GLDM_ROTY(1.0)
    GLDM_COLOR(VGCOL_RED)
    GLDM_DRAW(VG_GLDRAW_CPK_SOLID)
    GLDM_STEPZ(3.1)
    GLDM_SLEEP(60)
    GLDM_STEPZ(0)

    GLDM_SLEEP(TM_COLOR)        // Color loop
    GLDM_COLOR(VGCOL_ORANGE)
    GLDM_SLEEP(TM_COLOR)
    GLDM_COLOR(VGCOL_YELLOW)
    GLDM_SLEEP(TM_COLOR)
    GLDM_COLOR(VGCOL_GREEN)
    GLDM_SLEEP(TM_COLOR)
    GLDM_COLOR(VGCOL_CYAN)
    GLDM_SLEEP(TM_COLOR)
    GLDM_COLOR(VGCOL_BLUE)
    GLDM_SLEEP(TM_COLOR)
    GLDM_COLAT
    GLDM_SLEEP(TM_COLOR)

    GLDM_STEPZ(-0.2)            // Zoom out
    GLDM_SLEEP(25)
    GLDM_STEPZ(0)
    GLDM_SLEEP(100)

    GLDM_SURFCALC(10)           // Surface
    GLDM_IF(DMFL_NOTSUBTITLES, 100)
    GLDM_TEXT("Van der Waals surface", TXT_LOWLEFT)

  GLDM_LABEL(100)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(700)
    GLDM_SURFCOLAT
    GLDM_SLEEP(700)
    GLDM_SURFCOLP
    GLDM_IF(DMFL_NOTSUBTITLES, 110)
    GLDM_TEXT("MEP surface", TXT_LOWLEFT)

  GLDM_LABEL(110)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(400)
    GLDM_DRAW(VG_GLDRAW_WIREFRAME)
    GLDM_ATMLBL(VG_ATMLBL_CHARGE)
    GLDM_IF(DMFL_NOTSUBTITLES, 120)
    GLDM_TEXT("Labels of atomic charges", TXT_LOWLEFT)

  GLDM_LABEL(120)

    GLDM_SLEEP(500)
    GLDM_TEXT("", TXT_LOWLEFT)
    GLDM_ATMLBL(VG_ATMLBL_NONE)
    GLDM_STEPZ(-3.1)
    GLDM_SLEEP(60)

    /**** IMPDH ****/

    GLDM_NEW
    GLDM_IF(DMFL_NOTSUBTITLES, 130)
    GLDM_TEXT("Loading ...", TXT_LOWLEFT)
    GLDM_SLEEP(5)

  GLDM_LABEL(130)

    GLDM_LOAD("impdh.pdb.bz2")
    GLDM_CENTX(0.0)
    GLDM_CENTY(0.0)
    GLDM_CENTZ(-200.0)
    GLDM_ROTY(1.0)
    GLDM_COLOR(VGCOL_BLUE)
    GLDM_DRAW(VG_GLDRAW_WIREFRAME)
    GLDM_TEXT("", 0)

    GLDM_STEPZ(0.5)
    GLDM_SLEEP(180)
    GLDM_STEPZ(0)
    GLDM_ROTY(1.0)
    GLDM_IF(DMFL_NOTSUBTITLES, 140)
    GLDM_TEXT("Inosine monophosphate dehydrogenase", TXT_LOWLEFT)

  GLDM_LABEL(140)

    GLDM_SLEEP(200)
    GLDM_COLAT
    GLDM_SLEEP(100)
    GLDM_TEXT("", 0)
    GLDM_SLEEP(500)
    GLDM_ROTZ(1.0)
    GLDM_IF(DMFL_NOTSUBTITLES, 150)
    GLDM_TEXT("8598 atoms", TXT_LOWLEFT)

  GLDM_LABEL(150)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)

    GLDM_SLEEP(100)
    GLDM_ROTX(1.0)
    GLDM_IF(DMFL_NOTSUBTITLES, 160)
    GLDM_TEXT("497 water molecules", TXT_LOWLEFT)

  GLDM_LABEL(160)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)

    GLDM_SLEEP(100)
    GLDM_IF(DMFL_NOTSUBTITLES, 170)
    GLDM_TEXT("More than 20.000 vectors", TXT_LOWLEFT)

  GLDM_LABEL(170)

    GLDM_SLEEP(300)
    GLDM_TEXT("", 0)

    GLDM_SLEEP(600)

    GLDM_STEPZ(0.2)
    GLDM_SLEEP(300)
    GLDM_STEPZ(0)

    GLDM_SLEEP(800)

    GLDM_STEPZ(-1.0)
    GLDM_VOLUME(200)
    GLDM_SLEEP(50)
    GLDM_VOLUME(150)
    GLDM_SLEEP(50)
    GLDM_VOLUME(100)
    GLDM_SLEEP(50)
    GLDM_VOLUME(50)
    GLDM_SLEEP(25)
    GLDM_VOLUME(25)
    GLDM_SLEEP(25)
    GLDM_VOLUME(0)
    GLDM_STEPZ(0)

    /**** End ****/

    GLDM_NEW
    GLDM_SLEEP(TM_TITLE)
    GLDM_STOPSONG
    GLDM_LOOP
GLDM_END
