
/*************************************************
****            VEGA - OpenGL Fonts           ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <GL\gl.h>
#include <GL\glu.h>
#include <GL\glaux.h>
#include <stdio.h>
#include <stdarg.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "gl_global.h"

/**** Local variables ****/

static GLuint	base;


/**** Build bitmap fonts ****/

VG_BOOL GL_BuildFont(int Height, int Width)
{
  HFONT         font;

  base = glGenLists(96);		            // Storage For 96 Characters

  if (font = CreateFont( Height,		    // Height Of Font
                         Width,			    // Width Of Font
               	         0,			    // Angle Of Escapement
		         0,			    // Orientation Angle
		         FW_DONTCARE,     	    // Font Weight
		         FALSE,			    // Italic
		         FALSE,			    // Underline
		         FALSE,			    // Strikeout
		         ANSI_CHARSET,		    // Character Set Identifier
		         OUT_TT_PRECIS,		    // Output Precision
		         CLIP_DEFAULT_PRECIS,	    // Clipping Precision
		         ANTIALIASED_QUALITY,	    // Output Quality
		         FF_DONTCARE|DEFAULT_PITCH, // Family And Pitch
		         "Arial")) {

    SelectObject(hDC, font);			    // Selects The Font We Want

    wglUseFontBitmaps(hDC, 32, 96, base);	    // Builds 96 Characters Starting At Character 32
    return TRUE;
  }

  return FALSE;
}


/**** Delete the font ****/

void GL_KillFont(void)
{
  glDeleteLists(base, 96);
}


/**** Print routine ****/

void GL_Print(const char *fmt, ...)
{
  char		text[256];
  va_list  	ap;

  if (fmt) {
    va_start(ap, fmt);
    vsprintf(text, fmt, ap);
    va_end(ap);

    glPushAttrib(GL_LIST_BIT);				// Pushes The Display List Bits
    glListBase(base - 32);				// Sets The Base Character to 32
    glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
    glPopAttrib();					// Pops The Display List Bits
  }
}
