
/*************************************************
****        VEGA - OpenGL Global Header       ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifndef  __GL_GLOBAL_H
#define  __GL_GLOBAL_H

/**** Parameters ***/

#define  VG_CONSOLE_HEIGTH              120
#define  VG_SPLASH_FILE                 "Logo.bmp"

/**** Constants ****/

#define  VG_GLDEF_MANROTSTEP            (0.5 * PI / 180.0)
#define  VG_GLDEF_ROTSTEP               0.3
#define  VG_GLDEF_ROTSTEPINC            0.1
#define  VG_GLDEF_TRANSSTEP             5.0
#define  VG_GLDEF_ZOOMSTEP              0.2

/**** Anti alias modes ****/

#define  VG_GLAA_NONE                   0
#define  VG_GLAA_HARDWARE               1
#define  VG_GLAA_ACCUM                  2

/**** Draw modes ****/

#define  VG_GLDRAW_WIREFRAME            1
#define  VG_GLDRAW_VDW_DOTTED           2
#define  VG_GLDRAW_VDW_WIRE             3
#define  VG_GLDRAW_VDW_SOLID            4
#define  VG_GLDRAW_CPK_WIRE             5
#define  VG_GLDRAW_CPK_SOLID            6
#define  VG_GLDRAW_LIQUORICE            7

#define  VG_GLDRAW_MODES                7

/**** Mouse modes ****/

#define  VG_MOUSE_ROT                   0
#define  VG_MOUSE_TRANS                 1
#define  VG_MOUSE_SCALE                 2
#define  VG_MOUSE_MODES                 3

/**** Cpk modes ****/

#define  VG_CPKMOD_SOLID                0
#define  VG_CPKMOD_WIRE                 1
#define  VG_CPKMOD_LIQUORICE            2

/**** VdW modes ****/

#define  VG_VDWMOD_SOLID                0
#define  VG_VDWMOD_WIRE                 1
#define  VG_VDWMOD_DOTTED               2

/**** Structures ****/

typedef struct _VG_GL_PREFS {
  XYZ           Center;                 /* View center           */
  XYZ           StepRot;                /* Steps for rotation    */
  XYZ           StepTrans;              /* Steps for translation */
  VG_ULONG      RenderedAtoms;          /* Rendered atoms        */
  float         Scale;                  /* Scale                 */
  VG_ULONG      WsizeX, WsizeY;         /* Window size           */
  VG_ULONG      SsizeX, SsizeY;         /* Screen size           */
  VG_ULONG      Sdepth;                 /* Screen bitplanes      */
  VG_BOOL       FullScreen;             /* Full screen flag      */
  VG_BOOL       Animation;              /* Animation mode        */
  VG_BOOL       Demo;                   /* Demo mode             */
  VG_BOOL       DemoText;               /* Show text in demo     */
  VG_UWORD      DrawMode;               /* Draw mode             */
  VG_ULONG      Refresh;                /* Refresh time          */
  VG_ULONG      TotMol;                 /* Loaded molecules      */
  VG_BOOL       ShowFps;                /* Show fps              */
  VG_BOOL       PlayMusic;              /* Play the music        */
  char          *TxtStr;                /* Text string           */
  VG_BOOL       SrfAct;                 /* Surface list active   */
  VG_BOOL       Light;                  /* Light                 */
  VG_UWORD      MouseMode;              /* Mouse mode            */
  VG_UWORD      PickedAtoms;            /* Number of picked atms */
  void          (*PickCall)(struct _VG_GL_PREFS *, ATOMO *);
  void          *PickWin;               /* Pick window           */
  VG_UWORD      MeasureMode;            /* Measure mode          */
  VG_BOOL       SmartMove;              /* Smart move            */
  VG_BOOL       Render;                 /* Perform the rendering */
  VG_ULONG      DemoFX;                 /* Demo FX active        */
} VG_GLPREFS;

/**** Default preferences ****/

#ifndef __DEFSONLY

#ifndef __GLU_H__
#include <gl\glu.h>
#endif

#ifdef __OPENGL_MAIN
XYZ         LastCent     = {0.0, 0.0, 0.0};
GLfloat     RotMat[4][4] = {1.0, 0.0, 0.0, 0.0,
                            0.0, 1.0, 0.0, 0.0,
                            0.0, 0.0, 1.0, 0.0,
                            0.0, 0.0, 0.0, 1.0
                           };

VG_GLPREFS  ViewPrefs  = { {0.0, 0.0, 0.0},     /* View center           */
                           {0.0, 0.0, 0.0},     /* Steps for rotation    */
                           {0.0, 0.0, 0.0},     /* Step for translation  */
                           0,                   /* Rendered atoms        */
                           1.0,                 /* Scale                 */
                           640, 480,            /* Window size           */
                           640, 480,            /* Screen size           */
                           32,                  /* Screen bitplanes      */
                           FALSE,               /* Full screen flag      */
                           FALSE,               /* Animation mode        */
                           FALSE,               /* Demo mode             */
                           TRUE,                /* Show text in demo     */
                           VG_GLDRAW_WIREFRAME, /* Draw mode             */
                           1000 / 75,           /* Refresh time          */
                           0,                   /* Loaded molecules      */
                           FALSE,               /* Show fps              */
                           TRUE,                /* Play the music        */
                           NULL,                /* Text string           */
                           FALSE,               /* Surface list active   */
                           TRUE,                /* Light                 */
                           VG_MOUSE_ROT,        /* Mouse mode            */
                           0,                   /* Number of picked atms */
                           NULL,                /* Pick call-back func.  */
                           NULL,                /* Pick window           */
                           VG_PM_PICKNONE,      /* Measure mode          */
                           FALSE,               /* Smart move            */
                           FALSE,               /* Perform the rendering */
                           0                    /* Demo FX active        */
                         };
#  ifdef WIN32
HDC             hDC        = NULL;              /* Device context        */
HGLRC           hRC        = NULL;              /* Rendering context     */
HINSTANCE       hInstance  = NULL;              /* Application instance  */
HMENU           hMenu      = NULL;              /* Main menu handle      */
HMENU           hPopUpMenu = NULL;              /* Popup menu handle     */
HWND            hWnd       = NULL;              /* Main window handle    */
#  endif
#else
extern XYZ              LastCent;
extern GLfloat          RotMat[4][4];
extern VG_GLPREFS       ViewPrefs;

#  ifdef WIN32
extern HDC              hDC;
extern HGLRC            hRC;
extern HINSTANCE        hInstance;
extern HMENU            hMenu, hPopUpMenu;
extern HWND             hWnd;
#  endif
#endif

/**** Prototipes ****/

#  ifdef __cplusplus
extern "C" {
#  endif
void       ChangeAnimMenu(VG_BOOL);
void       ChangeConMenu(int);
void       ChangeLblAtmMenu(VG_ULONG);
void       ChangeLightMenu(VG_BOOL);
void       ChangeMousePopup(void);
void       ChangePickPopup(void);
HWND       CreateGLWindow(char *, VG_GLPREFS *);
void       GL_AntiAlias(VG_UWORD, VG_BOOL);
VG_BOOL    GL_BuildFont(int, int);
void       GL_BuildSpheres(int);
void       GL_CalcResRange(ATOMO *, VG_ULONG *, VG_ULONG *);
void       GL_ChangeMenu(VG_ULONG);
VG_BOOL    GL_ClipCopy(FILEFORMAT *);
VG_BOOL    GL_ClipCopyBmp(void);
VG_BOOL    GL_ClipCut(void);
FILEFORMAT *GL_ClipGetFormat(VG_ULONG);
VG_BOOL    GL_ClipPaste(void);
VG_ULONG   GL_ColorByAtm(ATOMO *);
VG_ULONG   GL_ColorByChain(ATOMO *);
VG_ULONG   GL_ColorByCharge(ATOMO *);
VG_ULONG   GL_ColorByMol(ATOMO *);
VG_ULONG   GL_ColorByRes(ATOMO *);
VG_ULONG   GL_ColorBySeg(ATOMO *);
VG_ULONG   GL_ColorMol(ATOMO *, VG_UBYTE);
void       GL_ColorSrf(VG_SURFACE *, VG_UBYTE);
void       GL_ColorSrfAtm(VG_SURFACE *, ATOMO *);
void       GL_ColorSrfCol(VG_SURFACE *, VG_ULONG);
void       GL_ColorSrfColRGB(VG_SURFACE *, VG_UBYTE, VG_UBYTE, VG_UBYTE);
void       GL_Cylinder(float *, float *, int, float, float, int);
VG_BOOL    GL_DemoCallBack(VG_GLPREFS *, float, VG_BOOL *);
void       GL_DemoDrawFX(void);
char       *GL_DemoGetPath(char *);
VG_BOOL    GL_DemoInitFX(void);
void       GL_DemoRelaseFX(void);
void       GL_DemoStart(VG_GLPREFS *);
void       GL_DemoStop(VG_GLPREFS *);
void       GL_DepthCue(VG_BOOL);
void       GL_DrawAtm(ATOMO *);
void       GL_DrawAtmLbl(ATOMO *);
void       GL_DrawCpk(ATOMO *, VG_UWORD);
void       GL_DrawDev(VG_GLPREFS *);
VG_BOOL    GL_DrawScene(VG_GLPREFS *, VG_BOOL);
void       GL_DrawTube(ATOMO *Atm);
void       GL_DrawWireframe(ATOMO *);
void       GL_DrawVdw(ATOMO *, VG_UWORD);
void       GL_EnableJoy(VG_UBYTE *);
void       GL_FmodClose(void);
VG_BOOL    GL_FmodErr(void);
VG_BOOL    GL_FmodInit(void);
VG_BOOL    GL_FmodPlayStream(char *, unsigned int);
void       GL_FmodReleaseStream(void);
void       GL_FmodSetVolume(int);
VG_UBYTE   GL_GetColorId(char *);
VG_UBYTE   GL_GetColorIdRGB(VG_ULONG);
void       GL_KillFont(void);
void       GL_KillSpheres(void);
void       GL_Measure(VG_GLPREFS *, ATOMO *);
int        GL_MessageBox(char *, char *, int);
VG_BOOL    GL_MenuExe(char *);
ATOMO      *GL_PickAtom(VG_GLPREFS *, GLint, GLint);
void       GL_PickWinActivate(HWND, void (*Call)(VG_GLPREFS *, ATOMO *));
void       GL_PickWinRemove(HWND);
void       GL_Print(const char *, ...);
VG_BOOL    GL_PrintWindow(void);
void       GL_Reset(VG_GLPREFS *);
void       GL_ResetMtx(VG_GLPREFS *);
void       GL_ResetView(VG_GLPREFS *);
void       GL_ReSizeScene(VG_ULONG, VG_ULONG);
void       GL_RotXYZ (int, int, int, double, GLfloat [4][4]);
VG_BOOL    GL_SaveWindow(char *);
VG_ULONG   GL_Select(ATOMO *, char *, VG_BOOL);
void       GL_SelectAll(ATOMO *, VG_BOOL);
VG_ULONG   GL_SelectBackBone(ATOMO *);
VG_ULONG   GL_SelectElem(ATOMO *, VG_UWORD, VG_BOOL);
void       GL_SelectInv(ATOMO *);
VG_ULONG   GL_SelectRng(ATOMO *, VG_UWORD, VG_ULONG, VG_ULONG, VG_BOOL);
VG_ULONG   GL_SelectWat(ATOMO *, VG_BOOL);
void       GL_SetAtmLbl(ATOMO *, VG_UBYTE);
void       GL_ShowSrf(VG_SURFACE *);
void       GL_SwapRotMat(void);
VG_BOOL    InitGL(void);
VG_BOOL    IsBackBoneAtm(register ATOMO *);
void       KillGLWindow(HWND);
void       MC_New(void);
VG_BOOL    MC_Open(char *, VG_BOOL);

#  ifdef __cplusplus
}
#  endif
#endif
#endif
