
/*************************************************
****       VEGA - Interactive measures        ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <gl\gl.h>
#include <gl\glu.h>
#include <gl\glaux.h>
#include <stdio.h>
#include <math.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "gl_global.h"
#include "gl_prefs.h"
#include "gl_menu.h"

/**** Constants ****/

#define  VG_SELBUFSIZE          512
#define  VG_SELSIZE             15.0


/**** Interactive measure *****/

void GL_Measure(VG_GLPREFS *Prf, ATOMO *PickedAtm)
{
  PLANE               P0, P1;
  static ATOMO        *AtmList[6];

  ATOMO               *Atm;
  float               x, y, z;

  if (Prf -> MeasureMode == VG_PM_PICKCENTER) {

        CatPrintf(stdout, MSG_GLMEAS_CENTER, Prf -> Center.x, Prf -> Center.y,
              Prf -> Center.z);

    Prf -> Center.x = PickedAtm -> x;
    Prf -> Center.y = PickedAtm -> y;
    Prf -> Center.z = PickedAtm -> z;

   x = PickedAtm -> x;
   y = PickedAtm -> y;
   z = PickedAtm -> z;
    for(Atm = BegAtm; Atm; Atm = Atm -> Ptr) {
      Atm -> x -= x;
      Atm -> y -= y;
      Atm -> z -= z;
    }

    CatPrintf(stdout, MSG_GLMEAS_CENTER,  x, y, z);
  } else {
    CatPrintf(stdout, MSG_GLMEAS_PICKATM, PickedAtm -> Num, PickedAtm -> Name.C,
              PickedAtm -> ResName.C, PickedAtm -> ResSeq.C);
    if (PickedAtm -> ChainID != ' ')
      LocPrintf(stdout, ":%c", PickedAtm -> ChainID);
    LocPrintf(stdout, "\n");

    if (Prf -> MeasureMode > VG_PM_PICKATOM) {
      AtmList[Prf -> PickedAtoms++] = PickedAtm;
      switch(Prf -> MeasureMode) {
      case VG_PM_PICKDIST:       /* Distance */
        if (Prf -> PickedAtoms == 2) {
          CatPrintf(stdout, MSG_GLMEAS_DIST, Distance(AtmList[0], AtmList[1]));
          Prf -> PickedAtoms = 0;
        }
        break;

      case VG_PM_PICKANG:      /* Angle */
        if (Prf -> PickedAtoms == 3) {
          CatPrintf(stdout, MSG_GLMEAS_ANGLE, NormAngle(BondAngle(AtmList[0],
                    AtmList[1], AtmList[2])));
          Prf -> PickedAtoms = 0;
        }
        break;

      case VG_PM_PICKTOR:     /* Torsion */
        if (Prf -> PickedAtoms == 4) {
          CatPrintf(stdout, MSG_GLMEAS_TORSION, NormAngle(Torsion(AtmList[0],
                    AtmList[1], AtmList[2], AtmList[3])));
          Prf -> PickedAtoms = 0;
        }
        break;

      case VG_PM_PICKPLANG:     /* Angle between two planes */
        if (Prf -> PickedAtoms == 6) {
          PlaneCof(&P0, AtmList[0], AtmList[1], AtmList[2]);
          PlaneCof(&P1, AtmList[3], AtmList[4], AtmList[5]);
          CatPrintf(stdout, MSG_GLMEAS_PLANG,
                    NormAngle(PlaneAngle(&P0, &P1) * RAD_TO_DEG));
          Prf -> PickedAtoms = 0;
        }
        break;
      } /* End of switch */
    }
  }
}


/**** Find the picked atom ****/

ATOMO *GL_PickAtom(VG_GLPREFS *Prf, GLint x, GLint y)
{
  ATOMO                 *PickedAtm;
  GLuint                SelectBuf[VG_SELBUFSIZE];
  GLint                 ViewPort[4];
  register ATOMO        *Atm;

  glGetIntegerv(GL_VIEWPORT, ViewPort);
  glSelectBuffer(VG_SELBUFSIZE, SelectBuf);
  glRenderMode(GL_SELECT);
  glInitNames();
  glPushName(0);
  glMatrixMode(GL_PROJECTION);
  glPushMatrix() ;
    glLoadIdentity();
    gluPickMatrix((GLdouble)x, (GLdouble)(ViewPort[3] - y),
                  VG_SELSIZE, VG_SELSIZE, ViewPort);
    gluPerspective(45.0f, (GLfloat)ViewPort[2] / (GLfloat)ViewPort[3], 0.1f,
                   GlPrefs -> GlZClip);
    glPushMatrix();
      glTranslatef(Prf -> Center.x, Prf -> Center.y, Prf -> Center.z);
      glMultMatrixf((const float *)RotMat);
      glScalef(Prf -> Scale, Prf -> Scale, Prf -> Scale);

      for(Atm = BegAtm; Atm; Atm = Atm -> Ptr) {
        if (Atm -> Active) {
          glPushName((GLuint)Atm);
          glBegin(GL_POINTS);
            glVertex3f(Atm -> x, Atm -> y, Atm -> z);
          glEnd();
          glPopName();
        }
      } /* End of for */
    glPopMatrix();
  glPopMatrix();
  if (!glRenderMode(GL_RENDER))
    PickedAtm = NULL;
  else
    PickedAtm = (ATOMO *)SelectBuf[4];

  glMatrixMode(GL_MODELVIEW);

  if (PickedAtm) {
    if (PickedAtm -> Label == VG_ATMLBL_NONE)
      PickedAtm -> Label = VG_ATMLBL_NAME;
    else
      PickedAtm -> Label = VG_ATMLBL_NONE;
  }

  return PickedAtm;
}


