
/*************************************************
****     VEGA - Prefs for OpenGL interface    ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "gl_global.h"
#include "winutils.h"
#define  __GL_PREFS_DEF
#include "gl_prefs.h"

/**** Local prototypes ****/

static FILE *GL_PrefsOpen(char *);


/**** Shift last file ****/

void GL_PrefsAddLastFile(register GLPREFS *Prf, char *NewFile)
{
  register VG_WORD      k;

  VG_BOOL               Chk = TRUE;

  if (*Prf -> LastFile[0]) {
    for(k = 0; (Chk) && (k < VG_GLPRF_FILEHIST); ++k) {
      if (stricmp(Prf -> LastFile[k], NewFile) == 0) {
        while (k) {
          strcpy(Prf -> LastFile[k], Prf -> LastFile[k - 1]);
          --k;
        }
        Chk = FALSE;
      }
    } /* End of for */

    if (Chk) {
      for(k = VG_GLPRF_FILEHIST - 1; k > 0; --k)
        strcpy(Prf -> LastFile[k], Prf -> LastFile[k - 1]);
    }
  }

  strcpy(Prf -> LastFile[0], NewFile);
}


/**** Reload the default settings for the display ****/

void GL_PrefsDefaultDisplay(GLPREFS *Prf)
{
  Prf -> GlCpkCylRad     = GlPrefsDef.GlCpkCylRad;
  Prf -> GlCpkCylRes     = GlPrefsDef.GlCpkCylRes;
  Prf -> GlCpkScale      = GlPrefsDef.GlCpkScale;
  Prf -> GlCpkSphereRes  = GlPrefsDef.GlCpkSphereRes;

  Prf -> GlLiqCylRes     = GlPrefsDef.GlLiqCylRes;
  Prf -> GlLiqSphereRes  = GlPrefsDef.GlLiqSphereRes;
  Prf -> GlLiqCylRad     = GlPrefsDef.GlLiqCylRad;

  Prf -> GlVdwDotSize    = GlPrefsDef.GlVdwDotSize;
  Prf -> GlVdwSphereRes  = GlPrefsDef.GlVdwSphereRes;

  Prf -> GlWireTick      = GlPrefsDef.GlWireTick;
  Prf -> GlSmoothWire    = GlPrefsDef.GlSmoothWire;

  Prf -> GlAntiAlias     = GlPrefsDef.GlAntiAlias;
  Prf -> GlDepthCue      = GlPrefsDef.GlDepthCue;
  Prf -> GlZClip         = GlPrefsDef.GlZClip;

  Prf -> SmartMoveEnable = GlPrefsDef.SmartMoveEnable;
  Prf -> SmartMoveAtoms  = GlPrefsDef.SmartMoveAtoms;

  GL_AntiAlias(GlPrefs -> GlAntiAlias, FALSE);
  GL_DepthCue(GlPrefs -> GlDepthCue);
}


/**** Free the GL preferences ****/

void GL_PrefsFree(GLPREFS *Prf)
{
  if (Prf != &GlPrefsDef)
    FREE(Prf);
}


/**** Get last file name ****/

char *GL_PrefsGetLastFile(VG_ULONG k, VG_BOOL Full)
{
  static char   Buf[256];

  char          *Ptr = (GlPrefs -> LastFile[k]);

  if ((Full) || (!*Ptr)) return Ptr;

  Buf[0] = k + '1';
  Buf[1] = ' ';
  Buf[2] = 0;
  if  (strlen(Ptr) > VG_GLPRF_FILELEN) {
    strcat(Buf, "...\\");
    strcat(Buf, GetFileName(Ptr));
  } else strcat(Buf, Ptr);

  return Buf;
}


/**** Load the GL preferences ****/

GLPREFS *GL_PrefsLoad(void)
{
  FILE          *FH;
  GLPREFS       *Prf;
  VG_ULONG      Val;

  VG_BOOL       Ret = FALSE;

  if (Prf = (GLPREFS *)Alloca(sizeof(GLPREFS))) {
    memcpy(Prf, &GlPrefsDef, sizeof(GLPREFS));
    if ((FH = GL_PrefsOpen("rb")) != NULL) {

      /**** Check the file type ****/

      if (fread(&Val, sizeof(VG_ULONG), 1, FH) == 1) {
        if (Val == VG_GLPRF_HDR) {

          /**** Read the size ****/

          if (fread(&Val, sizeof(VG_ULONG), 1, FH) == 1) {

            /**** Read the glprefs file ****/

            if (Val > sizeof(GLPREFS)) Val = sizeof(GLPREFS);
            if (fread(&Prf -> Version, Val - (2 * sizeof(VG_ULONG)), 1, FH) == 1) {

              /**** Check the parameters ****/

              if ((Prf -> OsType != VEGA_OSTYPE) ||
                  ((Prf -> Version & 0xff00) != (VG_GLPRF_VERSION & 0xff00))) {
                memcpy(Prf, &GlPrefsDef, sizeof(GLPREFS));
                Ret = TRUE;
              }
            } else PrintDosErr();
          } else PrintDosErr();
        }
      } else PrintDosErr();
      fclose(FH);
    } else Ret = TRUE;
  } else {
    Prf = &(GLPREFS)GlPrefsDef;
    Ret = TRUE;
  }

  if (Ret) {
    PrintWarn(GetStr(MSG_GLPRF_ERR_DEFAULT));
  }

  return Prf;
}


/**** Open the GL preferences file ****/

static FILE *GL_PrefsOpen(char *Mode)
{
  char          FileName[256];

  GetPrgPath(FileName, TRUE);
  sprintf(FileName + strlen(FileName), VG_GLPRF_FILE, VegaPort);

  return fopen(FileName, Mode);
}


/**** Save the GL preferences ****/

VG_BOOL GL_PrefsSave(GLPREFS *Prf)
{
  FILE          *FH;
  VG_BOOL       Ret;

  if ((FH = GL_PrefsOpen("wb")) != NULL) {
    Prf -> Len = sizeof(GLPREFS);
    if (fwrite(Prf, sizeof(GLPREFS), 1, FH) != 1)
      Ret = PrintDosErr();
    else
      Ret = TRUE;
    fclose(FH);
  } else Ret = PrintDosErr();

  return Ret;
}


/**** Set the GL preferences ****/

void GL_PrefsSet(GLPREFS *Prf)
{
#ifdef __WIN32__
  RECT          Rect;
#endif

  if (Prf != &GlPrefsDef) {
#ifdef __WIN32__

    /**** Main Window ****/

    GetWindowRect(hWnd, &Rect);
    Prf -> Version       = VG_GLPRF_VERSION;
    Prf -> OsType        = VEGA_OSTYPE;
    Prf -> MainWin.PosX  = Rect.left;
    Prf -> MainWin.PosY  = Rect.top;
    Prf -> MainWin.SizeX = Rect.right  - Rect.left;
    Prf -> MainWin.SizeY = Rect.bottom - Rect.top;
#endif

    Prf -> MM_Connect    = GLOBSW_CONNSAV;
  }
}


