
/*************************************************
****        VEGA - Selection utilities        ****
**** Copyright 1996-2001, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <GL\gl.h>
#include <GL\glu.h>
#include <stdio.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "gl_global.h"
#include "gl_colors.h"
#include "gl_menu.h"
#include "gl_prefs.h"
#include "compar.h"


/**** Select atom(s) ****/

VG_ULONG GL_Select(register ATOMO *Atm, char *Sel, VG_BOOL Val)
{
  char          *Ptr, *MyArg[4];

  VG_ULONG      k        = 0;
  VG_ULONG      Selected = 0;

  MyArg[0] = Sel;
  for(Ptr = Sel;*Ptr; ++Ptr) {
    if (*Ptr == ':') {
      ++k;
      if (k <= 3) {
        *Ptr = 0;
        MyArg[k] = Ptr + 1;
      } else break;
    }
  } /* End of for */

  switch(k) {
  case 0:       /* Only one argument*/
    if (ChkArgType(Sel, strlen(Sel), (VG_UBYTE)(VG_PARTYPE_UINT|VG_PARTYPE_NOZERO))) {
      sscanf(Sel, "%d", &k);
      while(Atm) {
        if (Atm -> Num == k) {
          Atm -> Active = Val;
          Selected = 1;
          break;
        }
        Atm = Atm -> Ptr;
      } /* End of while */
    } else {
      while(Atm) {
        if (Wildncmp(Sel, Atm -> Name.C, 4)) {
          Atm -> Active = Val;
          ++Selected;
        }
        Atm = Atm -> Ptr;
      } /* End of while */
    }
    break;

  case 1:       /* Two arguments: AtomName:ResidueName */
    while(Atm) {
      if ((Wildncmp(MyArg[0], Atm -> Name.C, 4)) &&
          (Wildncmp(MyArg[1], Atm -> ResName.C, 4))) {
        Atm -> Active = Val;
        ++Selected;
      }
      Atm = Atm -> Ptr;
    } /* End of while */
    break;

  case 2:       /* Three arguments: AtomName:ResidueName:ResidueNumber */
    while(Atm) {
      if ((Wildncmp(MyArg[0], Atm -> Name.C, 4)) &&
          (Wildncmp(MyArg[1], Atm -> ResName.C, 4)) &&
          (Wildncmp(MyArg[2], Atm -> ResSeq.C, 4))) {
        Atm -> Active = Val;
        ++Selected;
      }
      Atm = Atm -> Ptr;
    } /* End of while */
    break;

  case 3:       /* Four arguments: AtomName:ResidueName:ResidueNumber:Chain */
    while(Atm) {
      if ((Wildncmp(MyArg[0], Atm -> Name.C   , 4)) &&
          (Wildncmp(MyArg[1], Atm -> ResName.C, 4)) &&
          (Wildncmp(MyArg[2], Atm -> ResSeq.C , 4)) &&
          (Wildncmp(MyArg[3], &Atm -> ChainID , 1))) {
        Atm -> Active = Val;
        ++Selected;
      }
      Atm = Atm -> Ptr;
    } /* End of while */
  } /* End of switch */


  return Selected;
}


/**** Select backbone ****/

void GL_SelectAll(register ATOMO *Atm, register VG_BOOL Val)
{
  while(Atm) {
    Atm -> Active = Val;
    Atm = Atm -> Ptr;
  } /* End of while */
}


/**** Select backbone ****/

VG_ULONG GL_SelectBackBone(register ATOMO *Atm)
{
  register VG_ULONG     Selected = 0;

  while(Atm) {
    if (IsBackBoneAtm(Atm)) {
      Atm -> Active = TRUE;
      ++Selected;
    } else Atm -> Active = FALSE;
    Atm = Atm -> Ptr;
  } /* End of while */

  return Selected;
}


/**** Select an element ****/

VG_ULONG GL_SelectElem(register ATOMO *Atm, register VG_UWORD Elem, register VG_BOOL Val)
{
  register VG_ULONG     Selected = 0;

  while(Atm) {
    if (Atm -> Elem.S == Elem) {
      Atm -> Active = Val;
      ++Selected;
    }
    Atm = Atm -> Ptr;
  } /* End of while */

  return Selected;
}


/**** Invert the selection ****/

void GL_SelectInv(register ATOMO *Atm)
{
  while(Atm) {
    Atm -> Active = !Atm -> Active;
    Atm = Atm -> Ptr;
  } /* End of while */
}


/**** Select range ****/

VG_ULONG GL_SelectRng(register ATOMO *Atm, VG_UWORD Mode, register VG_ULONG Start,
                      register VG_ULONG End, register VG_BOOL Val)
{
  VG_ULONG              Temp;

  VG_ULONG              Selected = 0;

  if (Start > End) {
    Temp = Start;
    Start = End;
    End   = Temp;
  }

  while(Atm) {
    if (!Mode)                   /* Atom range   */
      Temp = Atm -> Num;
    else                        /* Residue range */
      Temp = Char2Int(Atm -> ResSeq.C, 4);

    if ((Temp >= Start) && (Temp <= End)) {
      Atm -> Active = Val;
      ++Selected;
    }
    Atm = Atm -> Ptr;
  } /* End of while */

  return Selected;
}


/**** Select an element ****/

VG_ULONG GL_SelectWat(register ATOMO *Atm, register VG_BOOL Val)
{
  register ATOMO        *H1, *H2;

  register VG_ULONG     Selected = 0;

  while(Atm) {
    H1 = Atm -> Conn[0];
    H2 = Atm -> Conn[1];

#ifdef LITTLE_ENDIAN
    if ((Atm -> Elem.S == 0x4f) && (Atm -> NSost == 2) &&
        (H1 -> Elem.S == 0x48) && (H2 -> Elem.S == 0x48)) {
#else
    if ((Atm -> Elem.S == 0x4f00) && (Atm -> NSost == 2) &&
        (H1 -> Elem.S == 0x4800) && (H2 -> Elem.S == 0x4800)) {
#endif
      Atm -> Active = Val;
      H1  -> Active = Val;
      H2  -> Active = Val;
      ++Selected;
    }
    Atm = Atm -> Ptr;
  } /* End of while */

  return Selected;
}


/**** Check if the atom is in the backbone ****/

VG_BOOL IsBackBoneAtm(register ATOMO *Atm)
{
  register VG_ULONG     j, k;

  const VG_QCHAR        BackList[] = {{"N" }, {"CA"}, {"C"},
                                      {"O5*"}, {"P" }, {"O3*"}, {"C5*"}, {"C4*"}, {"C3*"}
                                     };
  VG_BOOL               Ret        = FALSE;

  for(k = 0; k < 9; ++k) {
    if (Atm -> Name.L == BackList[k].L) {
      for(j = 0; (!Ret) && (j < (VG_ULONG)Atm -> NSost); ++j) {
        for(k = 0; k < 9; ++k) {
          if (Atm -> Conn[j] -> Name.L == BackList[k].L) {
            Ret = TRUE;
            break;
          }
        } /* End of for */
      } /* End of for */
      break;
    }
  } /* End of for */
  return Ret;
}

