
/*************************************************
****         VEGA - Global definitions        ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifndef  __GLOBDEF
#define  __GLOBDEF

#ifndef __VG_TYPES
#  include "vgtypes.h"
#endif

#define  VEGA_COPYRIGHT     "1996-2002"
#define  VEGA_DATE          "11.12.2002"     /* Release date          */
#define  VEGA_VERSTR        "1.4.3"          /* Version & release str */
#define  VEGA_VERSION       1                /* Version               */
#define  VEGA_RELEASE       4                /* Release               */
#define  VEGA_CAT_VER       2                /* Min. catalog version  */
#define  VEGA_EMAIL         "mailto:alessandro.pedretti@unimi.it"
#define  VEGA_WEB           "http://www.ddl.unimi.it"
#define  FF_UNIV_FILE       "UNIV.tem"

#define  bittst(bit,num)    ((num) >> (bit) & 1)
#define  vgCube(X)          ((X) * (X) * (X))
#define  Quad(X)            ((X) * (X))
#define  QuadDist(A,B)      (Quad((A) -> x - (B) -> x) +  \
                             Quad((A) -> y - (B) -> y) +  \
                             Quad((A) -> z - (B) -> z))
#define  Distance(A,B)      (SQR(QuadDist((A), (B))))

#define  CONV               (PI / 180.0)

#define  VG_INFINITE        ((float)3.4e+38)

#define  RAD_TO_DEG         (180.0 / PI)
#define  DEBYE_CONST        4.8
#define  DEG_TO_RAD         (PI / 180.0)
#define  LINELEN            256         /* I/O line buffer length I/O                */
#define  MAXTRJATM          12          /* Max number of atom in trajectory analysis */
#define  PI                 M_PI
#define  RETURNSTR_SIZE     4096        /* Size of the return string                 */
#define  SRFNAMELEN         100         /* Max lenght of surface name                */

/**** Atom flags ****/

#define  ATM_FLG_GENERIC    128         /* For generic use */

/**** Type of molecule ****/

#define  MOL_UNK            0          /* Unknown      */
#define  MOL_PROT           1          /* Protein      */
#define  MOL_NUCAC          2          /* Nucleic acid */

/**** Type of charge template ****/

#define  CHARGE_FRAG        0
#define  CHARGE_GAST        1

/**** Options for SubArg subroutine ****/

#define  SUBA_NOCHK         0
#define  SUBA_TOUP          1
#define  SUBA_POSFLOAT      2
#define  SUBA_POSINT        3

/**** Error modes ****/

#define  VG_ERRMOD_CONSOLE   0
#define  VG_ERRMOD_WINDOW    1
#define  VG_ERRMOD_QUIET     2

/****        Global switches        ****/
/**** Please don't change the order ****/

#define  GLOBSW_IFFIIUB         GlobSwitch[0]    /* Saves the IFF IIUB chunk    */
#define  GLOBSW_CONNSAV         GlobSwitch[1]    /* Saves the connectivity      */
#define  GLOBSW_IFFCALC         GlobSwitch[2]    /* Saves the IFF CALC chunk    */
#define  GLOBSW_CONNCALC        GlobSwitch[3]    /* Calculates the connectivity */
#define  GLOBSW_STDOUT          GlobSwitch[4]    /* Sets the output to stdout   */
#define  GLOBSW_MESTRJ          GlobSwitch[5]    /* Make a mesure in trajectory */
#define  GLOBSW_OPENGL          GlobSwitch[6]    /* OpenGL mode                 */

/**** Parameters for surface calculation ****/

#define  VLOGP_DOT_DENSITY              7
#define  VLOGP_PROBE_RAD              1.5
#define  ILM_PROBE_RAD                1.4

/**** Memory mamagment ****/

#define  ALLOC(X)           calloc((X), 1)
#define  FREE               free

/**** Reset the endian definitions ****/

#ifdef BIG_ENDIAN
#  undef    BIG_ENDIAN     /* MSB first: 68000, ibm, net */
#endif
#ifdef LITTLE_ENDIAN
#  undef  LITTLE_ENDIAN    /* LSB first: i386, vax */
#endif

/**** Windows 9x/NT definitions ****/

#if defined(__WIN32__) && !defined(WIN32)
#  define  WIN32
#endif

/**** Silicon Graphics definitions ****/

#ifdef sgi
#  define  VEGA_OSTYPE        1
#  define  SQR                fsqrt
#  define  BIG_ENDIAN
#else
#  define  SQR                sqrt
#endif


/**** AmigaOS definitions ****/

#ifdef AMIGA
#  define  VEGA_OSTYPE        2
#  define  SOALLOC(X)         calloc((X), 1)
#  define  SOFREE             free
#  define  BIG_ENDIAN
/*
#  define  SOALLOC(X)         AllocVec((X), MEMF_ANY | MEMF_CLEAR)
#  define  SOFREE             FreeVec
*/
#else
#  define  SOALLOC(X)         calloc((X), 1)
#  define  SOFREE             free
#endif

/**** Linux x86 definitions ****/

#ifdef linux
#  define  VEGA_OSTYPE        3
#  define  LITTLE_ENDIAN
#endif

/**** Win32 definitions ****/

#ifdef WIN32
#  define  VEGA_OSTYPE        4
#  define  __VG_OPENGL
#  define  LITTLE_ENDIAN
#  define  BIODOCK_EXE        "BioDock.exe"
#  define  MOPAC_EXE          "MoPac.exe"
#  define  WINDD_EXE          "WinDD.exe"
#  define  ERROR_PROMPT       "\n%s %d: %s.\n\n"
#  define  strcasecmp         strcmpi
#  define  strncasecmp        strnicmp
#  define  C_DIRSEP           "\\"
#  define  LocPrintf          DosPrintf
#else
#  define  C_DIRSEP           "/"
#  define  ERROR_PROMPT       "\n\033[33m%s %d:\033[0m %s.\n\n"
#  define  LocPrintf          fprintf
#endif

/**** Generic OS *****/

#ifndef VEGA_OSTYPE
#  define  VEGA_OSTYPE        99
#endif

/**** Html help files ****/

#define  HELP_FILE          "Docs" C_DIRSEP "Html" C_DIRSEP "index.htm"
#define  MOPAC_HELP_FILE    "Docs" C_DIRSEP "Text" C_DIRSEP "Mopac.txt"

/**** Plane coefficients ****/

typedef struct {
  float     a, b, c, d;
} PLANE;

/**** Double precision vector ****/

typedef struct {
  double    x, y, z;
} VECTYPE;

/**** Generic XYZ vector (sngle precision) ****/

typedef struct {
  float   x, y, z;
} XYZ;

/**** Atom description ****/

typedef struct {
  VG_ULONG         Num;            /* Atom number               */
  VG_QCHAR         Name;           /* Atom name                 */
  VG_QCHAR         ResName;        /* Residue name              */
  VG_QCHAR         ResSeq;         /* Number of residue         */
} ATMDESC;

/**** Force field parameter structure ****/

typedef struct {
  char              *CPtr;
  char              *Beg;
  FILE              *FFIN;    /* File Handle                  */
  VG_ULONG          Line;     /* Current template line number */
  VG_ULONG          TotArgs;  /* Total number of arguments    */
  VG_UWORD          Args;     /* Current argument             */
} FFPAR;

/**** Electronic descriptor ****/

typedef struct {
  VG_DCHAR          Atom;     /* Element                */
  VG_BYTE           NSost; /* Number of substituents */
  VG_BYTE           Npi;   /* Number of Pi electrons */
} HUCK;

/**** Force field descriptor for atomic types ****/

typedef struct {
  VG_DCHAR          Atom;     /* Element                */
  VG_BYTE           NSost;    /* Number of substituents */
  VG_BYTE           Ring;     /* Type of ring           */
  VG_BYTE           Arom;     /* The ring is aromatic ? */
  VG_BYTE           NSub;     /* Sublevel number        */
} FFDESC;

/**** File format structure ****/

typedef struct {
  VG_LONG           Id;       /* Identification code */
  char              *Com;     /* Command token       */
  char              *Ext;     /* File extension      */
  VG_LONG           Flags;    /* Control flags       */
  VG_LONG           MsAllow;  /* Allowed mesures     */
} FILEFORMAT;

/**** Used with loader subroutine ****/

typedef union {
  char              Line[LINELEN + 1];
  VG_LONG           Hdr;
} RECORD;

/**** Internal coordinates ****/

typedef struct {
  ATOMO             *Ptr;
  int               na, nb, nc;
  float             r, w, t;
  int               pos[3];
} ATMINT;

/**** Atom list for selection ****/

typedef struct __ATMLST {
  struct __ATMLST       *Ptr;           /* Pointer to next structure  */
  VG_ULONG              Num;            /* Atom number                */
  VG_QCHAR              Name;           /* Atom name                  */
  VG_QCHAR              ResSeq;         /* Residue number             */
  VG_QCHAR              ResName;        /* Residue name               */
  ATOMO                 *Atm;           /* Atom ptr after translation */
  char                  ChainID;        /* Chain indicator            */
} ATMLST;

/**** Atom selection (see ATMLST) ****/

typedef struct __ATMSEL {
  struct __ATMSEL       *Ptr;           /* Pointer to next structure   */
  char                  Name[14];       /* Selection name              */
  VG_WORD               Type;           /* Selection type              */
  VG_ULONG              TotAtm;         /* Number of atoms in the list */
  ATMLST                *BegList;       /* Atom list                   */
  ATMLST                *LastAtm;       /* Last atom of the list       */
  ATMLST                *SelAtm;        /* Selected atom pointer       */
  int                   SelAtmNum;      /* Selected atom number        */
} ATMSEL;

/**** Atom table ****/

typedef struct {
  VG_DCHAR          Atom;     /* Element name         */
  VG_UWORD          AtmNum;   /* Atomic number        */
  float             Mass;     /* Atomic mass          */
  float             CovRad;   /* Covalent radius      */
  float             VdwRad;   /* Van Der Waals radius */
} ATMTAB;

/**** Parameter for trajectory analysis ****/

typedef struct {
  char              **Arg;          /* Arg list pointer           */
  VG_UWORD          Num;            /* Number of atoms/args       */
  VG_UWORD          Com;            /* Command                    */
  VG_ULONG          Flags;          /* Atom selection flags       */
  char              *OutFile;       /* Ptr to output file name    */
  FILEFORMAT        *OutForm;       /* Output format              */
  ATMDESC           Atm[MAXTRJATM]; /* Atom descriptions          */
  ATMSEL            *Sel;           /* Selection                  */
} TRJPAR;

/**** To select a space region ****/

typedef struct {
  VG_ULONG          Points;         /* Number of points            */
  XYZ               Low;            /* Coordinates of lower corner */
  XYZ               Hi;             /* Coordinates of high corner  */
  XYZ               StepS;          /* Step size                   */
  VG_ULONG          StX, StY, StZ;  /* Number of steps             */
  TRJPAR            *Par;           /* Pointer to parameters       */
} SPACEREG;

/**** Trajectory info ****/

typedef struct {
  FILE          *FH;                /* File handle               */
  float         *Energy;            /* Energy buffer             */
  VG_ULONG      EneFrames;          /* Energy frames             */
  float         EneMax, EneMin;     /* Value range               */
  VG_ULONG      EneStep;            /* Energy step               */
  VG_ULONG      ConvStep;           /* Energy step -> frame step */
  VG_ULONG      Format;             /* Trajectory format         */
  VG_ULONG      Frames;             /* Number of frames          */
  VG_ULONG      FrmStep;            /* Frame step                */
  VG_ULONG      FrmCur;             /* Current frame number      */
  VG_ULONG      FrmMax;             /* Max. energy frame         */
  VG_ULONG      FrmMin;             /* Lowest energy frame       */
  VG_ULONG      MolAtm;             /* Number of atom            */
  float         Temp;               /* Temperature               */
  VG_ULONG      StartTime;          /* Start time                */
  VG_ULONG      StartData;          /* File data pointer         */
  VG_ULONG      *SeekTab;           /* Fast seek table           */
  XYZ           *VectorBuf;         /* Vector buffer             */
} TRJINFO;

/**** Preferences ****/

typedef struct {
  char              LANGUAGE[20];   /* Language for strings translation       */
  char              MOPAC_DEF[80];  /* Mopac: default parameters              */
  VG_WORD           MOPAC_CRG;      /* Mopac: total charge                    */
  VG_WORD           MOPAC_MMOK;     /* Mopac: polipeptidic correction         */
  VG_BOOL           MOPAC_FLAG;     /* Mopac: TRUE when manual parameters     */
  float             SAS_PROBERAD;   /* SAS: probe radius                      */
  VG_LONG           SAS_POINTS;     /* SAS: points density                    */
  FILEFORMAT        *OUTFORMAT;     /* Number of output format                */
  VG_ULONG          RENSTART;       /* Starting residue for renumber          */
  VG_ULONG          MAXATMINFO;     /* Max atoms for extra infos (-f INFO)    */
  VG_QCHAR          ENRESNAME;      /* Residue name for energy calculation    */
  VG_QCHAR          ENRRESSEQ;      /* Residue number for energy calculation  */
  float             ENCUTOFF;       /* Cutoff distance for energy calculation */
  float             ENFILTER;       /* Filter for energy calculation          */
  float             ENDIEL;         /* Dielectric for energy calculation      */
  float             VOL_DEN;        /* Dot density for volume calclulation    */
  float             SOL_RAD;        /* Solvatation radius                     */
  VG_WORD           SOL_SHAPE;      /* Shape (0=Cubic, 1=Sphere, 2=shell      */
  char              *DCD_FILE;      /* Name of trajectory file                */

  /**** OpenGL specific preferences ****/

  VG_ULONG          MOPAC_MAXATM;   /* Mopac: max number of atoms             */
  float             CHART_ZOOMFACT; /* Zoom in/out factor for chart window    */
  VG_BOOL           SYS_GLASSWIN;   /* Enable/disable glass windows           */
} PREFS;

#endif

