
/**************************************************
****               VEGA - Globvar              ****
****  Definitions of variables and prototypes  ****
****  Copyright 1996-2002, Alessandro Pedretti ****
**************************************************/


#ifndef __GLOBVAR
#define  __GLOBVAR

/**** Global variables ****/

#ifndef __MAIN
extern ATMSEL      *BegSel, *LastSel;
extern ATMTAB      AtmTable[];
extern ATOMO       *BegAtm, *LastAtm;
extern char        AATab[], FFName[], GlobSwitch[], OutFile[], *OutFName[];
extern char        ErrStr[];
extern const char  *PackExt[], *ShapeType[], *VrmlHdr;
extern const char  *PDBAtmRec[], *PrgName, *VEGAHdr;
extern VG_QCHAR    AAEquivTab[], AAResTab[];
extern PREFS       Prefs;
extern SPACEREG    Region;
extern TRJINFO     TrjInfo;
extern VG_SURFACE  *BegSrf;
extern VG_UBYTE    *MatchMtx;
extern VG_ULONG    AtmLoaded, GlobErr, TotalAtm, TotalSrf;
extern VG_UWORD    ErrMode;
extern void        *Catalog;

#ifdef WIN32
extern char        *ReturnStr;
#endif
#endif

#define  PkClose        MyClose

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif
void       AddPackExt(char *, VG_UWORD);
void       AddToRad(ATOMO *, float *, float);
ATOMO      *AlchemyLoad(FILE *, RECORD *, VG_ULONG *);
VG_BOOL    AlchemySave(FILE *, ATOMO *, VG_ULONG);
void       *Alloca(VG_ULONG);
ATOMO      *AllocAtm(ATOMO **, VG_ULONG *);
VG_SURFACE *AllocSrfDot(VG_SURFACE **, VG_ULONG *);
float      *AssignCovRad(ATOMO *, VG_ULONG);
VG_BOOL    AssignVdwNew(ATOMO *, float, float *);
float      *AssignVdwRad(ATOMO *, VG_ULONG, float, float *);
VG_BOOL    AssignFF(char *, ATOMO *, VG_ULONG, VG_BOOL);
VG_BOOL    AssignTriposFF(ATOMO *, VG_ULONG);
void       AtmToAtdl(char *, ATOMO *);
VG_BOOL    AtmTrans(ATOMO *, VG_ULONG, TRJPAR *);
VG_ULONG   AttToOrd(ATOMO *);
void       BioDockClose(TRJINFO *);
VG_BOOL    BioDockOpen(char *, TRJINFO *);
VG_BOOL    BioDockReadFrm(TRJINFO *);
VG_BOOL    BioDockSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
double     BondAngle(ATOMO *, ATOMO *, ATOMO *);
ATOMO      *CarLoad(FILE *, RECORD *, VG_ULONG *);
void       CalcBox(ATOMO *, float *, XYZ *, XYZ *);
float      CalcDipole(ATOMO *, VG_ULONG);
float      CalcIlm(ATOMO *, float, VG_ULONG);
void       CalcGeoCent(register ATOMO *,register XYZ *, VG_BOOL);
XYZ        *CalcSfUn(VG_ULONG, float, VG_ULONG *);
float      CalcSrfArea(ATOMO *, float *, XYZ *, VG_ULONG, TRJPAR *, float, float *, VG_ULONG);
float      CalcSrfIlm(ATOMO *, float, float, float, float);
float      CalcSrfMep(ATOMO *, float, float, float);
VG_BOOL    CalcSrfPsa(ATOMO *);
float      CalcVLogP(ATOMO *, float *, float, XYZ *, VG_ULONG, float *, VG_ULONG);
float      CalcVolume(ATOMO *, float *, float, XYZ *, XYZ *, VG_ULONG);
VG_BOOL    CarSave(FILE *, ATOMO *, VG_WORD);
void       CatClose(void);
VG_BOOL    CatErr(VG_ULONG, ...);
VG_BOOL    CatInit(void);
int        CatPrintf(FILE *, VG_ULONG, ...);
VG_ULONG   Char2Int(char *, VG_ULONG);
void       ChangeExt(char *, char *, char *);
VG_BOOL    Charge(char *, VG_UWORD, ATOMO *, VG_ULONG);
VG_LONG    ChargeBySeq(ATOMO *);
void       ChargeErr(char *, char *, VG_ULONG);
void       ChargeMol(VG_UWORD);
VG_BOOL    ChkCharges(ATOMO *, VG_ULONG, float *);
VG_BOOL    ChkForceField(ATOMO *, VG_ULONG);
VG_BOOL    ChkFFAtm(ATOMO *, FFDESC *);
VG_BOOL    ChkTempFF(char *, char *);
void       CloseAll(void);
void       CloseAllMol(void);
void       CloseSrf(void);
VG_BOOL    Connect(ATOMO *, VG_ULONG);
VG_ULONG   CountBond(ATOMO *);
VG_ULONG   CountRes(ATOMO *);
void       CrossProd(VECTYPE *, VECTYPE *, VECTYPE *);
ATOMO      *CRDLoad(FILE *, RECORD *, VG_ULONG *);
VG_BOOL    CRDSave(FILE *, ATOMO *, VG_ULONG);
ATOMO      *CSSRLoad(FILE *, RECORD *, VG_ULONG *, VG_UWORD);
VG_BOOL    CSSRSave(FILE *, ATOMO *, VG_ULONG, VG_UWORD);
void       DCDClose(TRJINFO *);
VG_BOOL    DCDLoadEne(FILE *, TRJINFO *);
VG_BOOL    DCDLoadNamdOut(FILE *, TRJINFO *);
VG_BOOL    DCDOpen(char *, TRJINFO *);
VG_BOOL    DCDReadFrm(FILE *, ATOMO *);
VG_BOOL    DCDSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
float      Det2x2(float, float, float, float);
void       Disalloca(void *);
double     Dot(VECTYPE *, VECTYPE *);
VG_BOOL    Errore(const char *, ...);
VG_BOOL    FastaSave(FILE *, ATOMO *);
void       FFPop(ATOMO *, VG_ULONG *);
VG_ULONG   *FFPush(ATOMO *, VG_ULONG);
VG_BOOL    FileExists(char *);
VG_ULONG   FileLength(FILE *);
VG_LONG    FindRes(ATOMO *, VG_ULONG);
VG_ULONG   FindResPtr(ATOMO *, ATOMO **, VG_LONG, VG_LONG);
void       FindRing(ATOMO *);
VG_BOOL    ForRead(FILE *, void *, VG_ULONG);
VG_BOOL    ForSeek(FILE *, VG_ULONG, VG_BOOL);
void       ForStrCpy(char *, char *, VG_ULONG);
VG_BOOL    ForWrite(FILE *, void *, VG_ULONG);
ATOMO      *GamessLoad(FILE *, RECORD *, VG_ULONG *);
VG_BOOL    GamessSave(FILE *, ATOMO *, char *);
VG_BOOL    Gasteiger(char *, ATOMO *, VG_ULONG);
VG_UWORD   GetAtmNum(VG_UWORD);
char       *GetFileName(char *);
VG_BOOL    GetPrefsRes(char *);
VG_BOOL    GetPrgPath(char *, VG_BOOL);
void       GetTmpDir(char *, unsigned int);
void       GetTmpFileName(char *);
char       *GetStr(VG_ULONG);
ATOMO      *GromosLoad(FILE *, RECORD *, VG_ULONG *);
VG_BOOL    GromosSave(FILE *, ATOMO *, VG_ULONG,  float);
ATOMO      *HINLoad(FILE *, RECORD *, VG_ULONG *);
ATOMO      *IFFLoad(FILE *, VG_ULONG, VG_ULONG *);
VG_BOOL    IFFSave(FILE *, ATOMO *, VG_ULONG);
float      IlmClacCutOff(ATOMO *);
VG_BOOL    InfoSave(FILE *, ATOMO *, VG_ULONG);
void       InitConn(void);
ATOMO      *Loader(char *, VG_ULONG *, VG_LONG *, VG_ULONG);
void       LoadPrefs(char *);
VG_SURFACE *LoadSrfInsight(FILE *, VG_ULONG *);
VG_SURFACE *LoadSrfQuanta(FILE *, VG_ULONG *);
VG_BOOL    LogPCalc(ATOMO *, VG_ULONG, float *, float *, char *, float *);
void       Lower(char *);
double     Magnitude(VECTYPE *);
VG_UWORD   MatchAtm(ATOMO *, FFDESC *, FFDESC *);
ATOMO      *MdlMolLoad(FILE *, RECORD *, VG_ULONG *);
VG_BOOL    MdlMolSave(FILE *, ATOMO *, VG_ULONG, char *);
ATOMO      *Mol2Load(FILE *, RECORD *, VG_ULONG *);
VG_BOOL    Mol2Save(FILE *, ATOMO *, VG_ULONG, char *);
ATOMO      *MoPacArcLoad(FILE *, RECORD *, VG_ULONG *);
float      MoPacChgCalc(ATOMO *, VG_ULONG);
VG_BOOL    MoPacChkMMOK(ATOMO *, VG_ULONG);
VG_BOOL    MoPacSave(FILE *, ATOMO *, VG_ULONG, char *, char *);
ATOMO      *MsfLoad(FILE *, VG_ULONG *);
VG_BOOL    MsfWrite(FILE *, ATOMO *, VG_ULONG);
VG_BOOL    MyClose(FILE *);
void       MyCloseAll(void);
void       Normalize(ATOMO *, VG_ULONG);
double     NormAngle(double Ang);
void       PDBClose(TRJINFO *);
void       PDBFree(ATOMO *);
ATOMO      *PDBLoad(FILE *, RECORD *, VG_ULONG *, VG_BOOL *);
VG_BOOL    PDBOpen(char *, TRJINFO *);
VG_BOOL    PDBReadFrm(TRJINFO *, ATOMO *);
VG_BOOL    PDBSave(FILE *, ATOMO *, VG_ULONG, VG_WORD);
VG_BOOL    PDBSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
FILE       *PkOpen(char *, char *, VG_UWORD, VG_BOOL);
FILE       *PkReOpen(FILE *, char *);
float      PlaneAngle(PLANE *, PLANE *);
float      PlaneAngAtm(ATOMO *);
void       PlaneCof(PLANE *, ATOMO *, ATOMO *, ATOMO *);
void       PointToVect(ATOMO *, VECTYPE *);
VG_BOOL    PrintAtmErr(char *, ATOMO *, VG_BOOL);
VG_BOOL    PrintDosErr(void);
void       PrintLoad(VG_ULONG, VG_ULONG);
void       PrintLogP(float, float);
void       PrintProg(VG_ULONG);
VG_BOOL    PrintVlogPErr(void);
void       PrintWarn(char *);
void       PrtCopyright(void);
FILE       *OpenPlot(char *, VG_UWORD *);
VG_UWORD   ReadNull(FILE *, char *, VG_UWORD);
void       RemoveAtm(ATOMO **, ATOMO **, ATOMO **);
void       RemoveH(ATOMO **, VG_ULONG *);
void       RemoveH2O(ATOMO **, VG_ULONG *);
void       RemoveRes(ATOMO **, ATOMO **, ATOMO **, VG_ULONG *);
ATOMO      *RenameRes(ATOMO *, VG_LONG);
VG_BOOL    RenameWat(ATOMO *);
void       RenAtm(ATOMO *, VG_ULONG);
void       RenRes(ATOMO *, VG_ULONG);
void       RestoreFF(ATOMO *, VG_LONG *);
VG_BOOL    Saver(char *, FILEFORMAT *, VG_UWORD, ATOMO *, VG_ULONG);
VG_BOOL    SelAtmChk(ATMLST *);
void       SelAtmRemAll(ATMSEL *);
void       SelRemAll(void);
ATMSEL     *SelRetPtr(VG_WORD, VG_WORD);
void       SetGlobErr(VG_ULONG);
void       SetTypeRes(VG_QCHAR *, VG_UBYTE);
VG_BOOL    SkipLines(FILE *, char *, VG_ULONG);
VG_BOOL    Solvate(char *, ATOMO *, VG_ULONG *);
VG_SURFACE *SrfCalc(VG_ULONG *, ATOMO *, VG_ULONG, VG_ULONG, float, VG_UWORD, float *, VG_ULONG);
void       SrfColorByVal(VG_SURFACE *);
VG_SURFACE *SrfCsvLoad(FILE *, VG_ULONG *);
VG_BOOL    SrfCsvSave(FILE *, VG_SURFACE *);
void       SrfFree(VG_SURFACE *);
VG_BOOL    SrfInsightSave(FILE *, char *, VG_SURFACE *, ATOMO *);
void       SrfName(char *, char *);
void       SrfPrintProg(VG_UWORD);
void       SrfPsaCalc(VG_SURFACE *, ATOMO **, ATOMO *, VG_ULONG, float *, float *);
ATOMO      **SrfPsaInitCalc(ATOMO *, VG_ULONG);
VG_BOOL    SrfQuantaSave(FILE *, char *, VG_SURFACE *Dot, ATOMO *);
VG_BOOL    SrfRawSave(FILE *, VG_SURFACE *);
VG_BOOL    SrfSave(FILE *, char *, VG_SURFACE *, VG_ULONG, ATOMO *, VG_UWORD);
VG_BOOL    SrfVrmlSave(FILE *, VG_SURFACE *, VG_BOOL);
VG_LONG    *StoreFF(ATOMO *, VG_ULONG);
void       Str2Dchar(VG_DCHAR *, char *);
void       Str2Qchar(VG_QCHAR *, char *);
VG_BOOL    SubArg(char **, VG_WORD, VG_BOOL);
VG_BOOL    Surface(FILE *, char *, ATOMO *, VG_ULONG, VG_ULONG, float, VG_UWORD, float *);
VG_BOOL    SybFldCalc(FILE *, ATOMO *, VG_ULONG, SPACEREG *);
VG_BOOL    SybRgnLoad(FILE *, RECORD *, SPACEREG *);
void       Swap(void *);
double     SwapD(double);
int        SwapI(int);
void       SwapW(void *);
int        SwapWrite(FILE *, void *);
VG_BOOL    ToDesc(FFPAR *, FFDESC *, char *);
double     Torsion(ATOMO *, ATOMO *, ATOMO *, ATOMO *);
VG_BOOL    TrjAnalyzer(char *, ATOMO *, VG_ULONG, TRJPAR *);
float      *TrjCalc(TRJINFO *, TRJPAR *, ATOMO *, VG_ULONG);
void       TrjCalcEne(TRJINFO *);
void       TrjClose(TRJINFO *);
VG_BOOL    TrjOpen(char *, TRJINFO *, VG_UWORD);
VG_BOOL    TrjParser(TRJPAR *);
VG_BOOL    TrjPlotSave(char *, VG_ULONG, float *, VG_ULONG);
VG_BOOL    TrjReadFrm(TRJINFO *, VG_ULONG);
VG_BOOL    TrjSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
VG_UWORD   TypeOfMol(ATOMO *);
void       Upper(char *);
double     VectAng(VECTYPE *, VECTYPE *);
void       VectDiff(VECTYPE *, VECTYPE *, VECTYPE *);
void       VegaGetString(char *, char *, VG_UWORD);
VG_BOOL    VrmlSave(FILE *, ATOMO *, VG_ULONG);
VG_BOOL    VrmlCpkSave(FILE *, ATOMO *, VG_ULONG);
VG_BOOL    VrmlSolSave(FILE *, ATOMO *, VG_ULONG);
int        Wildncmp(char *, char *, int);
void       XtcClose(TRJINFO *);
VG_BOOL    XtcLoadLog(FILE *, TRJINFO *);
VG_BOOL    XtcOpen(char *, TRJINFO *);
VG_BOOL    XtcReadFrm(TRJINFO *, ATOMO *);
VG_BOOL    XtcSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
ATOMO      *XyzLoad(FILE *, RECORD *, VG_ULONG *);
VG_BOOL    XyzSave(FILE *, ATOMO *);

/**** Special prototypes for Virtual logP ****/

#ifdef VLOGP
float      CalcSrfLogP(ATOMO *, float *, float, float, float, float *);
VG_BOOL    LogPCalc(ATOMO *, VG_ULONG, float *, float *, char *, float *);
#endif

/**** Special prototypes for Win32 systems ****/

#ifdef WIN32
VG_BOOL    LocaleInit(void);
int        DosPrintf(FILE *, char *, ...);
VG_BOOL    PluginCall(VG_ULONG, char *, VG_UWORD, void *);
void       PluginFree(void);
VG_ULONG   PluginLoad(void);
void       PluginMenuCall(VG_ULONG);
void       PluginMenuChange(VG_ULONG);
void       ProgBarClose(void);
void       ProgBarInit(char *, int);
VG_BOOL    ProgBarUpd(char *, int);
void       ResetGlobErr(void);
void       ShowLastErr(void);
VG_BOOL    WinErr(void);
#endif

/**** Special prototypes for OpenGL ****/

#ifdef __VG_OPENGL
int     GL_Start(void);
VG_BOOL GL_SrfSave(char *, VG_SURFACE *, ATOMO *, VG_UWORD, VG_UWORD);
#endif

#  ifdef __cplusplus
}
#  endif
#endif

