
/*************************************************
****       VEGA - Gromos loader & saver       ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"


/**** Gromos Loader ****/

ATOMO *GromosLoad(FILE *IN, register RECORD *Lin, VG_ULONG *TotAtomi)
{
  char              ResName[20], ResSeq[20];

  register ATOMO    *Atm     = NULL;
  ATOMO             *InizAtm = NULL;
  VG_ULONG          Num      = 0;

  if (fgets(Lin -> Line, LINELEN, IN)) {
    sscanf(Lin -> Line, "%d", &Num);
    if (Num >= 1) {
      while ((Num) && (fgets(Lin -> Line, LINELEN, IN))) {
        if ((*Lin -> Line != '\n') && (Lin -> Hdr != *(VG_LONG *)"END\n")) {
          if( (Atm = (ATOMO *)AllocAtm(&InizAtm, TotAtomi))) {
            strncpy(ResName, Lin -> Line, 5);
            ResName[5] = 0;
            sscanf(ResName, "%s", ResSeq);
            Str2Qchar(&Atm -> ResSeq , ResSeq);
            sscanf(Lin -> Line + 5, "%s %4s %*s %f %f %f",
                   ResName, Atm -> Name.C,
                   &Atm -> x, &Atm -> y, &Atm -> z);
            Atm -> x *= 10.0;
            Atm -> y *= 10.0;
            Atm -> z *= 10.0;
            Str2Qchar(&Atm -> ResName, ResName);
            Atm -> Elem.C[0] = toupper(Atm -> Name.C[0]);
            if ((Atm -> Name.C[1]) && (islower(Atm -> Name.C[1])))
              Atm -> Elem.C[1] = Atm -> Name.C[1];
            --Num;
          }
        }
      } /* End of while */
      if (Atm) {
        Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
        LastAtm       = Atm;
      }
    }
  } else PrintDosErr();

  return InizAtm;
}


/**** Gromos saver ****/

VG_BOOL GromosSave(FILE *OUT, register ATOMO *Atm, VG_ULONG TotAtm, float Scale)
{
  VG_BOOL		Ret = TRUE;

  if (fprintf(OUT, "%s\n" \
                   "%5d \n", VEGAHdr, TotAtm) > 0) {
    while((Ret) && (Atm)) {
      if (fprintf(OUT, "%5.4s%-4.4s  %-4.4s%5d%8.3f%8.3f%8.3f%8.4f%8.4f%8.4f\n",
                  Atm -> ResSeq.C, Atm -> ResName.C, Atm -> Name.C,
                  Atm -> Num, Atm -> x / Scale, Atm -> y / Scale ,
                  Atm -> z / Scale, 0.0, 0.0, 0.0) <= 0)
        Ret = PrintDosErr();
      Atm = Atm -> Ptr;
    }

  } else Ret = PrintDosErr();

  return Ret;
}
