
/*************************************************
****       VEGA - Loader & saver module       ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
# include <windows.h>
# include "Win32/Plugins/menucom.h"

extern HANDLE   hWnd;
#endif

#include <stdio.h>
#include <string.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "formats.h"
#include "globstr.h"
#include "iff.h"


#ifdef __VG_OPENGL
void    DlgTrjOpen(char *, VG_BOOL, VG_UWORD);
#endif


/************************************************
****         Autodetection subroutine        ****
****   return the pointer of atom structure  ****
**** or NULL if an error occurs or -2 if the ****
****         file contains data only         ****
************************************************/

ATOMO *Loader(char *MolFile, VG_ULONG *TotAtomi, VG_LONG *FormatID, VG_ULONG NMol)
{
  ATOMO      *TmpAtm;
  char       FileName[512];
  char       *Str;
  FILE       *MOLIN;
  RECORD     Line;
  VG_ULONG   IFFLen, Num;


  ATOMO      *BegPtr  = NULL;
  VG_BOOL    Brk      = FALSE;
  VG_BOOL    PDBMulti = FALSE;
  VG_BOOL    Ret      = TRUE;
  VG_LONG    FrmID    = 0;
  VG_ULONG   Count    = 0;
  VG_ULONG   *Ptr     = (VG_ULONG *)&Line;

  *GlobSwitch         = 0;
  *TotAtomi           = 0;

  /**** Binary format recognition with automatic decompression ****/

  if ((MOLIN = PkOpen(MolFile, "rb", NULL, FALSE)) != NULL) {
    if (fread(Line.Line, 40, 1, MOLIN) == 1) {

      /**** Quanta/MSF ****/

      if (!strncmp(Line.Line + (sizeof(VG_ULONG) * 4), "QUANTA", 6)) {
        PrintLoad(MSG_LOADER_MSF, NMol);
        FrmID  = FORM_QUANTA_MSF;
        BegPtr = MsfLoad(MOLIN, TotAtomi);
        GLOBSW_IFFIIUB = TRUE;
        GLOBSW_IFFCALC = TRUE;

        /**** DCD Quanta/CHARMm trajectory file ****/

      } else if (!strncmp(Line.Line + sizeof(VG_ULONG), "CORD", 4)) {
        Prefs.DCD_FILE = MolFile;
        strcpy(FileName, MolFile);
        ChangeExt(FileName, "msf", NULL);
        if (!FileExists(FileName)) ChangeExt(FileName, "CRD", NULL);
        if (!FileExists(FileName)) ChangeExt(FileName, "pdb", NULL);

        /**** Read the associated CRD/msf file ****/

        if ((GLOBSW_MESTRJ) || (GLOBSW_OPENGL)) {
          if ((BegPtr = Loader(FileName, TotAtomi, &FrmID, NMol)) == NULL)
            Ret = CatErr(MSG_ERR_LOADER_CRDASSFILE);
#ifdef __VG_OPENGL
          else if (GLOBSW_OPENGL) {
#ifdef WIN32
            SendMessage(hWnd, WM_COMMAND, VG_MM_NEW, 0);
#endif
            IFFLen    = TotalAtm;
            TmpAtm    = BegAtm;
            TotalAtm += *TotAtomi;
            BegAtm    = BegPtr;
            strcpy(FileName, MolFile);
            DlgTrjOpen(FileName, TRUE, FTRJ_DCD);
            TotalAtm  = IFFLen;
            BegAtm    = TmpAtm;
          }
#endif
        } else Ret = CatErr(MSG_ERR_LOADER_CRDMESURE);

      /**** Gromacs XTC trajectory ****/

      } else if (SwapI(Line.Hdr) == 1995) {
        Prefs.DCD_FILE = MolFile;
        strcpy(FileName, MolFile);
        ChangeExt(FileName, "gro", NULL);
        if (!FileExists(FileName)) ChangeExt(FileName, "pdb", NULL);

        /**** Read the associated gro/pdb file ****/

        if ((GLOBSW_MESTRJ) || (GLOBSW_OPENGL)) {
          if ((BegPtr = Loader(FileName, TotAtomi, &FrmID, NMol)) == NULL)
            Ret = CatErr(MSG_ERR_LOADER_CRDASSFILE);
#ifdef __VG_OPENGL
          else if (GLOBSW_OPENGL) {
#ifdef WIN32
            SendMessage(hWnd, WM_COMMAND, VG_MM_NEW, 0);
#endif
            IFFLen    = TotalAtm;
            TmpAtm    = BegAtm;
            TotalAtm += *TotAtomi;
            BegAtm    = BegPtr;
            strcpy(FileName, MolFile);
            DlgTrjOpen(FileName, TRUE, FTRJ_XTC);
            TotalAtm  = IFFLen;
            BegAtm    = TmpAtm;
          }
#endif
        } else Ret = CatErr(MSG_ERR_LOADER_CRDMESURE);

      /**** IFF format ****/

      } else if (!strncmp(Line.Line, "FORM", 4)) {
        fseek(MOLIN, 4, SEEK_SET);
        if ((fread(&IFFLen  , sizeof(VG_ULONG), 1, MOLIN) == 1) &&
            (fread(&Line.Hdr, sizeof(VG_LONG) , 1, MOLIN) == 1)) {
#ifdef LITTLE_ENDIAN
          Swap(&IFFLen);
#endif
          if (!strncmp(Line.Line, "MOLE", 4)) {
            PrintLoad(MSG_LOADER_IFF, NMol);
            BegPtr         = IFFLoad(MOLIN, IFFLen, TotAtomi);
            FrmID          = FORM_IFF;
            GLOBSW_IFFIIUB = TRUE;
          }
        } else Ret = PrintDosErr();

        /**** Quanta Surface ****/

#ifdef LITTLE_ENDIAN
      } else if ((Ptr[0] == 0x04000000) && (Ptr[1] == 0x01000000) &&
                 (Ptr[2] == 0x04000000) && (Ptr[3] == 0x64000000)) {
#else
      } else if ((Ptr[0] == 0x04) && (Ptr[1] == 0x01) &&
                 (Ptr[2] == 0x04) && (Ptr[3] == 0x64)) {
#endif
        FrmID = FORM_QUANTA_SRF;
#ifdef __VG_OPENGL
        if (GLOBSW_OPENGL) {
          fseek(MOLIN, 0, SEEK_SET);
          PrintLoad(MSG_LOADER_QNTSRF, NMol);
          Brk = TRUE;
          if (BegSrf = LoadSrfQuanta(MOLIN, &TotalSrf))
            BegPtr = (ATOMO *)-2;
          else
            BegPtr = (ATOMO *)-1;
        } else Ret = CatErr(MSG_ERR_LODER_OPENGLONLY);
#else
        Ret = CatErr(MSG_MAIN_ERR_OPENGL);
#endif
      } else {

        /**** ASCII format recognition ****/

        if ((MOLIN = PkReOpen(MOLIN, "r")) != NULL) {
          while((!Brk) && (fgets(Line.Line, LINELEN, MOLIN))) {

            switch(Count) {
            case 0:       /* 1st file line */

              /**** Alchemy format ****/

              if ((strstr(Line.Line, "ATOMS,")) &&
                  (strstr(Line.Line, "BONDS,")) &&
                  (strstr(Line.Line, "CHARGES"))) {
                PrintLoad(MSG_LOADER_ALCHEMY, NMol);
                BegPtr         = AlchemyLoad(MOLIN, &Line, TotAtomi);
                FrmID          = FORM_ALCHEMY;
                GLOBSW_IFFCALC = TRUE;
                Brk            = TRUE;

              /**** BioDock output ****/

              } else if (!strncmp(Line.Line, "#BIODOCK_VER", 11)) {
                 Prefs.DCD_FILE = MolFile;
#ifdef __VG_OPENGL
                 if (GLOBSW_OPENGL) {
#  ifdef WIN32
                   SendMessage(hWnd, WM_COMMAND, VG_MM_NEW, 0);
#  endif
                   IFFLen    = TotalAtm;
                   TmpAtm    = BegAtm;
                   DlgTrjOpen(MolFile, TRUE, FTRJ_BIODOCK);
                   *TotAtomi = TotalAtm;
                   TotalAtm  = IFFLen;
                   BegPtr    = BegAtm;
                   BegAtm    = TmpAtm;
                 }
#endif
                 Brk       = TRUE;
              }

              /**** Sybyl rgn format ****/

              if (!strncmp(Line.Line, "Filename:  ", 11)) {
                PrintLoad(MSG_LOADER_SYBREG, NMol);
                if (SybRgnLoad(MOLIN, &Line, &Region))
                  BegPtr = (ATOMO *)-2;
                else BegPtr = (ATOMO *)-1;
                Brk = TRUE;
              }

              /**** CSV surface ****/

              if ((strlen(Line.Line) == 90) &&
                  (Line.Line[ 6] == ';') && (Line.Line[23] == ';') &&
                  (Line.Line[40] == ';') && (Line.Line[57] == ';') &&
                  (Line.Line[74] == ';') && (Line.Line[79] == ';') &&
                  (Line.Line[84] == ';')) {
                FrmID = FORM_CSV_SRF;
#ifdef __VG_OPENGL
                if (GLOBSW_OPENGL) {
                  PrintLoad(MSG_LOADER_CSVSRF, NMol);
                  Brk      =  TRUE;
                  fseek(MOLIN, 0, SEEK_SET);
                  if (BegSrf = SrfCsvLoad(MOLIN, &TotalSrf))
                    BegPtr = (ATOMO *)-2;
                  else
                    BegPtr = (ATOMO *)-1;
                } else Ret = CatErr(MSG_ERR_LODER_OPENGLONLY);
#else
                Ret = CatErr(MSG_MAIN_ERR_OPENGL);
#endif
              }

              /**** CHARMm CRD format ****/

              if (*Line.Line == '*') {
                PrintLoad(MSG_LOADER_CRD, NMol);
                BegPtr         = CRDLoad(MOLIN, &Line, TotAtomi);
                FrmID          = FORM_CRD;
                GLOBSW_IFFCALC = TRUE;
                Brk            = TRUE;
              }

              /**** Insight surface ****/

              if (!strncmp(Line.Line, "DOTS", 4)) {
                FrmID = FORM_BIOSYM_SRF;
#ifdef __VG_OPENGL
                if (GLOBSW_OPENGL) {
                  PrintLoad(MSG_LOADER_INSSRF, NMol);
                  Brk      =  TRUE;
                  if (BegSrf = LoadSrfInsight(MOLIN, &TotalSrf))
                    BegPtr = (ATOMO *)-2;
                  else
                    BegPtr = (ATOMO *)-1;
                } else Ret = CatErr(MSG_ERR_LODER_OPENGLONLY);
#else
                Ret = CatErr(MSG_MAIN_ERR_OPENGL);
#endif
              }
              break;

            case 2:       /* 3rd file line */

              /**** QMC format ****/

              if ((!strncmp(Line.Line,"   1 ",5)) &&
                 (Line.Line[15] == '.') && (Line.Line[26] == '.') &&
                 (Line.Line[37] == '.') && (Line.Line[73] == '.')) {
                PrintLoad(MSG_LOADER_QMC, NMol);
                BegPtr         = CSSRLoad(MOLIN, &Line, TotAtomi, CSSR_QMC);
                FrmID          = FORM_QMC;
                GLOBSW_IFFCALC = TRUE;
                Brk            = TRUE;
              }
              break;

            case 3:       /* 4th file line */

            /**** MoPac Internal format ****/

              if (!strncmp(Line.Line + 6,
                  "0.0000000  0      0.000000  0      0.000000  0    0    0    0", 61)) {
                fseek(MOLIN, 0, SEEK_SET);
                PrintLoad(MSG_LOADER_MOPINT, NMol);
                BegPtr         = MoPacArcLoad(MOLIN, &Line, TotAtomi);
                FrmID          = FORM_MOPINT;
                GLOBSW_IFFCALC = TRUE;
                Brk            = TRUE;
              }
              break;

            case 4:       /* 5th file line */

              /**** CSSR format ****/

              if ((!strncmp(Line.Line,"   1 ",5)) &&
                  (!strncmp(Line.Line + 9, "  ",2))) {
                PrintLoad(MSG_LOADER_CSSR, NMol);
                BegPtr         = CSSRLoad(MOLIN, &Line, TotAtomi, CSSR_PURE);
                FrmID          = FORM_CSSR;
                GLOBSW_IFFCALC = TRUE;
                Brk            = TRUE;
              }
              break;

            } /* end of switch */

            if (!Brk) {

              /**** Biosym Archive 1 & 3 format ****/

              if (!strncmp("!BIOSYM archive", Line.Line, 15)) {
                PrintLoad(MSG_LOADER_CAR, NMol);
                BegPtr         = CarLoad(MOLIN, &Line, TotAtomi);
                FrmID          = FORM_BIOSYM;
                GLOBSW_IFFIIUB = TRUE;
                GLOBSW_IFFCALC = TRUE;
                break;
              }

              /**** MDL Mol format ****/

              if ((Line.Line[34] == 'V') && (Line.Line[36] == '0') &&
                (Line.Line[37] == '0') && (Line.Line[38] == '0')) {
                PrintLoad(MSG_LOADER_MDLMOL, NMol);
                BegPtr         = MdlMolLoad(MOLIN, &Line, TotAtomi);
                FrmID          = FORM_MDL;
                GLOBSW_IFFCALC = TRUE;
                Brk            = TRUE;
              }

              /**** PDB format ****/

              if ((Line.Hdr == *(VG_LONG *)PDBAtmRec[0]) ||
                  (Line.Hdr == *(VG_LONG *)PDBAtmRec[1]) ||
                  (Line.Hdr == *(VG_LONG *)"REMA")) {
                PrintLoad(MSG_LOADER_PDB, NMol);
                BegPtr         = PDBLoad(MOLIN, &Line, TotAtomi, &PDBMulti);
                FrmID          = FORM_PDB;
                GLOBSW_IFFIIUB = TRUE;
                break;
              }

              /**** HyperChem HIN format ****/

              if (!strncmp(Line.Line, "mol", 3)) {
                Num = 0;
                sscanf(Line.Line, "%*s %d", &Num);
                if (Num >= 1) {
                  PrintLoad(MSG_LOADER_HIN, NMol);
                  BegPtr         = HINLoad(MOLIN, &Line, TotAtomi);
                  FrmID          = FORM_HIN;
                  GLOBSW_IFFCALC = TRUE;
                  break;
                }
              }

              /**** MoPac .arc format ****/

              if (!strncmp(Line.Line, "          FINAL GEOMETRY OBTAINED", 33)) {
                PrintLoad(MSG_LOADER_MOPARC, NMol);
                BegPtr         = MoPacArcLoad(MOLIN, &Line, TotAtomi);
                FrmID          = FORM_MOPINT;
                GLOBSW_IFFCALC = TRUE;
                break;
              }

              /**** Sybyl Mol2 format ****/

              if (!strcmp(Line.Line, "@<TRIPOS>MOLECULE\n")) {
                PrintLoad(MSG_LOADER_MOL2, NMol);
                BegPtr         = Mol2Load(MOLIN, &Line, TotAtomi);
                FrmID          = FORM_MOL2;
                GLOBSW_IFFCALC = TRUE;
                break;
              }

              /**** Gamess ****/

              if ((strstr(Line.Line, "$DATA") != NULL) &&
                  (strstr(Line.Line, "INPUT") == NULL)) {
                PrintLoad(MSG_LOADER_GAMESS, NMol);
                BegPtr         = GamessLoad(MOLIN, &Line, TotAtomi);
                FrmID          = FORM_GAMESS;
                GLOBSW_IFFCALC = TRUE;
                break;
              }

              /**** Gamess output ****/

              if (strstr(Line.Line, "COORDINATES OF ALL ATOMS ARE") != NULL) {
                PrintLoad(MSG_LOADER_GAMESS, NMol);
                BegPtr         = GamessLoad(MOLIN, &Line, TotAtomi);
                FrmID          = FORM_GAMESS;
                GLOBSW_IFFCALC = TRUE;
                break;
              }

              /**** Gromax format ****/

              if (!strcmp(Line.Line, "POSITION\n")) {
                if (fgets(Line.Line, LINELEN, MOLIN)) {
                  PrintLoad(MSG_LOADER_GROMOS, NMol);
                  BegPtr         = GromosLoad(MOLIN, &Line, TotAtomi);
                  FrmID          = FORM_GROMOS;
                  GLOBSW_IFFCALC = TRUE;
                } else PrintDosErr();
                break;
              }

              /**** Gromos format ****/

              if ((Line.Line[24] == '.') && (Line.Line[32] == '.') &&
                  (Line.Line[40] == '.')) {
                PrintLoad(MSG_LOADER_GROMOS, NMol);
                fseek(MOLIN, 0, SEEK_SET);
                if (fgets(Line.Line, LINELEN, MOLIN)) {
                  BegPtr         = GromosLoad(MOLIN, &Line, TotAtomi);
                  FrmID          = FORM_GROMOS;
                  GLOBSW_IFFCALC = TRUE;
                } else PrintDosErr();
                break;
              }

              /**** XYZ format ****/

              if (*Line.Line != '\n') {
                IFFLen = 0;
                Num    = 1;
                for(Str = Line.Line; (*Str == ' ') || (*Str == '\t'); ++Str);
                  if ((*Str >= 'A') && (*Str <= 'Z')) {
                    ++Str;
                    if (((*Str >= 'A') && (*Str <= 'Z')) || (*Str == ' ') ||
                        (*Str == '\t')) {
                      ++Str;
                      if (*Str == ' ') {
                        ++Str;
                        while(*Str) {
                          if ((*Str >= '0') && (*Str <= '9')) {
                            ++Num;
                          } else {
                            if (*Str == '.') ++IFFLen;
                            if ((IFFLen > 3) ||
                                ((*Str != ' ') && (*Str != '.') &&
                                 (*Str != '\t') && (*Str != '+') &&
                                 (*Str != '-') && (*Str != 10) && (*Str != 13))) {
                              Num = 0;
                              break;
                            }
                          }
                          ++Str;
                        }
                      }
                    }
                  }
                if (Num >= 16) {
                  PrintLoad(MSG_LOADER_XYZ, NMol);
                  BegPtr = XyzLoad(MOLIN, &Line, TotAtomi);
                  FrmID  = FORM_XYZ;
                  break;
                }
              } /* End of XYZ format */
            }
            ++Count;
          } /* end of while loop */
        }
      }

      PkClose(MOLIN);
      if (BegPtr == (ATOMO *)-1) BegPtr = 0;
      else if ((!BegPtr) && (Ret)) {
        CatErr(MSG_ERR_LOADER_UNKFORMAT);
#ifdef __VG_OPENGL
      } else if ((FrmID == FORM_PDB) && (PDBMulti)) {
        IFFLen    = TotalAtm;
        TmpAtm    = BegAtm;
        TotalAtm += *TotAtomi;
        BegAtm    = BegPtr;
        DlgTrjOpen(MolFile, TRUE, FTRJ_PDB);
        TotalAtm  = IFFLen;
        BegAtm    = TmpAtm;
#endif
      }
      if (FormatID) *FormatID = FrmID;
    } else PrintDosErr();
  } else CatErr(MSG_ERR_LOADER_NOTFOUND);

  return BegPtr;
}



