
/*************************************************
****            VEGA - LogP Module            ****
**** Copyright 1996-2001, Alessandro Pedretti ****
*************************************************/

/*
 * Calculates the logP with atomic template methods
 * Broto/Moreau or Ghose/Crippen) and its lipole.
 */


#include <stdio.h>
#include <string.h>
#include <math.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"

#define  FIELDLEN            256

VG_BOOL LogPCalc(ATOMO *InizAtm, VG_ULONG TotAtm, float *LogP,
              float *MomLip, char *FF, float *Contrib)
{
  char                  Field[16], FieldName[FIELDLEN], Tmp[32];
  FILE                  *IN;
  float                 Cont, AbsCont;
  VG_QCHAR              Type;
  register ATOMO        *Atm;
  VG_ULONG              k;

  VG_BOOL               Ret   = TRUE;
  float                 ContP = 0.0;
  float                 ContN = 0.0;
  float                 Xp    = 0.0;
  float                 Yp    = 0.0;
  float                 Zp    = 0.0;
  float                 Xn    = 0.0;
  float                 Yn    = 0.0;
  float                 Zn    = 0.0;
  register VG_ULONG     Lin   = 0;
  VG_ULONG              Tot   = 0;

  GetPrgPath(FieldName, TRUE);
  strcat(FieldName, FF);
  strcat(FieldName, ".tem");

  if ((Ret = AssignFF(FieldName, InizAtm, TotAtm, TRUE))) {
    GetPrgPath(FieldName, TRUE);
    strcat(FieldName, FF);
    strcat(FieldName, ".par");
    if ((IN = fopen(FieldName, "r"))) {
      *LogP  = 0;
      strcpy(Tmp, "#FF_Param ");
      strcat(Tmp, FF);
      while(fgets(FieldName, FIELDLEN, IN)) {
        if ((!Lin) && (strncmp(FieldName, Tmp, strlen(Tmp)))) {
          Ret = CatErr(MSG_ERR_LOGP_UNRECFILE, FF);
          break;
        }
        if ((*FieldName) && (*FieldName != '\n') &&
            (*FieldName != ';') && (*FieldName != '#')) {
          *Field = 0;
          Cont   = 0;
          sscanf(FieldName, "%12s %f", Field, &Cont);
          if (*Field) {
            k = strlen(Field);
            if (k <= 4) {
              Type.L = 0;
              memcpy(Type.C, Field, k);
              AbsCont = fabs(Cont);
              for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
                if (Atm -> Pot.L == Type.L) {
                  if (Contrib) Contrib[Atm -> Num - 1] = Cont;
                  if (Cont > 0) {
                    Xp += Atm -> x * AbsCont;
                    Yp += Atm -> y * AbsCont;
                    Zp += Atm -> z * AbsCont;
                    ContP += AbsCont;
                  } else {
                    Xn += Atm -> x * AbsCont;
                    Yn += Atm -> y * AbsCont;
                    Zn += Atm -> z * AbsCont;
                    ContN += AbsCont;
                  }
                  *LogP += Cont;
                  ++Tot;
                }
              }
            }
          }
        }
        ++Lin;
      }
      fclose(IN);

      if (Tot == TotAtm) {
        if (ContP) {
          Xp /= ContP;
          Yp /= ContP;
          Zp /= ContP;
        }
        if (ContN) {
          Xn /= ContN;
          Yn /= ContN;
          Zn /= ContN;
        }
        *MomLip = SQR(Quad(Xp - Xn) + Quad(Yp - Yn) + Quad(Zp - Zn));
      } else Ret = CatErr(MSG_ERR_LOGP_NOTALLPAR, FF);
    } else Ret = CatErr(MSG_ERR_LOGP_NOTFOUND, FF);
  }

  return Ret;
}
