
/*************************************************
****            VEGA - Main include           ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifndef WIN32
#  include <unistd.h>
#  define  CLUSTER_DIR        "Clusters/"
#else
#  include <windows.h>
#  include "Win32/winutils.h"
#  include <stdlib.h>
#  define  CLUSTER_DIR        "Clusters\\"
#endif

#define  PREFS_FILE         "prefs"

/**** Control switches ****/

#define  SW_NORMALIZE       0 /* Normalize the coordinates    */
#define  SW_FFIELD          1 /* Assign the force field       */
#define  SW_SAVMOL          2 /* Save the molecule            */
#define  SW_RMHYDROG        3 /* Remove hydrogens             */
#define  SW_RMWATER         4 /* Remove water molecules       */
#define  SW_RENRES          5 /* Renumber the residues        */
#define  SW_CHARGES         6 /* Assign charges               */
#define  SW_NOCONNECT       7 /* Don't calculate connectivity */
#define  SW_FINDRINGS       8 /* Search the rings             */
#define  SW_SOLVATE         9 /* Solvate the molecule         */

/**** Definition for signal trapping ****/

typedef void (*fptr)();

#ifdef AMIGA
#  include <exec/libraries.h>
#  include <libraries/locale.h>

static char             *Versione    = "$VER:VEGA "VEGA_VERSTR" ("VEGA_DATE")";
struct Library          *LocaleBase  = NULL;
struct Library          *PPBase      = NULL;
unsigned long           __stack      = 32768;  /* Stack dimension */
#endif

#ifdef WIN32
char                    *ReturnStr   = NULL;
HINSTANCE               hFmod        = NULL;
HINSTANCE               hIl          = NULL;
HINSTANCE               hIlu         = NULL;
HINSTANCE               hIlut        = NULL;
HINSTANCE               hLibBz2      = NULL;
HINSTANCE               hZ32         = NULL;
HINSTANCE               hXdrf        = NULL;
HINSTANCE               hZlib32      = NULL;
#endif

/**** Global variables ****/

ATOMO                   *LastAtm;
char                    FFName[20];
char                    OutFile[256], ErrStr[256];
VG_UBYTE                *MatchMtx;
SPACEREG                Region;
TRJINFO                 TrjInfo;

ATMSEL                  *BegSel      = NULL;
ATMSEL                  *LastSel     = NULL;
ATOMO                   *BegAtm      = NULL;
char                    GlobSwitch[] = { FALSE, FALSE, FALSE, FALSE,
                                         FALSE, FALSE, FALSE };
const char              *PDBAtmRec[] = { "ATOM", "HETATM" };
const char              *PrgName     = "VEGA";
const char              *PackExt[]   = { "", "bz2", "gz", "pp", "Z", NULL };
const char              *ShapeType[] = { "BOX", "SPHERE", "LAYER", NULL };
const char              *VEGAHdr     = "File converted by VEGA V" VEGA_VERSTR;
const char              *VrmlHdr     = "#VRML V1.0 ascii\nSeparator {\n";
VG_SURFACE              *BegSrf      = NULL;
VG_ULONG                AtmLoaded    = 0;
VG_ULONG                GlobErr      = 0;
VG_ULONG                TotalSrf     = 0;
VG_ULONG                TotalAtm     = 0;
void                    *Catalog     = NULL;
VG_UWORD                ErrMode      = VG_ERRMOD_CONSOLE;


/**** Default preferences ****/

PREFS                   Prefs        = { {"english"},     /* Language for string translation        */
                                         {"AM1 PRECISE"}, /* Mopac: keywords                        */
                                         0,               /* Mopac: CHARGE=0                        */
                                         2,               /* Mopac: Auto polipeptidic bond          */
                                         FALSE,           /* Mopac: Automatic parameters            */
                                         1.4,             /* SAS: probe radius                      */
                                         10,              /* SAS: points density                    */
                                         &FileInfo[0],    /* PDB output format                      */
                                         1,               /* Starting residue for renumbering       */
                                         500,             /* Max atoms for extra infos (-f INFO)    */
                                         {""},            /* Residue name for energy calculation    */
                                         {"999"},         /* Residue number for energy calculation  */
                                         10.0,            /* Cutoff distance for energy calculation */
                                         1.0,             /* Filter for energy calculation          */
                                         1.0,             /* Dielectric for energy calculation      */
                                         100.0,           /* Dot density for volume calclulation    */
                                         10.0,            /* Solvatation radius                     */
                                         0,               /* Shape (0=box, 1=sphere, 2=shell)       */
                                         NULL,            /* Name of trajectory file                */

                                         /**** OpenGL specific preferences ****/

                                         50,              /* Mopac: max number of atoms             */
                                         25.0,            /* Zoom in/out factor for chart window    */
                                         TRUE             /* Enable Glass window                    */
                                       };




