
/*************************************************
****      VEGA - MDL Mol loader & saver       ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"

#ifdef LITTLE_ENDIAN
#  define  FF_TRIPOS_C2     0x00322e43
#else
#  define  FF_TRIPOS_C2     0x432e3200
#endif


/**** MDL Mol Loader ****/

ATOMO *MdlMolLoad(FILE *IN, RECORD *Lin, VG_ULONG *TotAtomi)
{
  register ATOMO        *Atm     = NULL;
  ATOMO                 *InizAtm = NULL;
  VG_ULONG              k        = 0;

  sscanf(Lin -> Line, "%3d", &k);
  while((k--) && (fgets(Lin -> Line, LINELEN, IN))) {
    if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
      sscanf(Lin -> Line, "%9f %9f %9f %3s",
             &Atm -> x, &Atm -> y, &Atm -> z, Atm -> Name.C);
      Atm -> Elem.C[0] = Atm -> Name.C[0];
      Atm -> Elem.C[1] = Atm -> Name.C[1];
    } else break;
  } /* End of while */

  if (Atm) {
    Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
    LastAtm       = Atm;
  }

  return InizAtm;
}


/**** MDL Mol saver ****/

VG_BOOL MdlMolSave(FILE *OUT, ATOMO *InizAtm, VG_ULONG TotAtm, char *FileName)
{
  ATOMO         *Atm;
  char          Bond, *Name, *Ptr;
  VG_QCHAR	Ord1, Ord2, Ord3;
  VG_UWORD	k;

  VG_BOOL       Ret = TRUE;

#ifdef __VG_OPENGL
  VG_LONG               *Store = NULL;

  if (GLOBSW_OPENGL)
    Store = StoreFF(InizAtm, TotAtm);
#endif
  if ((Ret = AssignTriposFF(InizAtm, TotAtm))) {
    if (fprintf(OUT, "%s\n" \
                     "  VEGA\n" \
                     "%3d%3d  0  0  0  0  0  0  0  0  1 V2000\n",
                     GetFileName(FileName), TotAtm, CountBond(InizAtm)) > 0) {
      for(Atm = InizAtm; (Ret) && (Atm); Atm = Atm -> Ptr) {
        if (fprintf(OUT, "%10.4f%10.4f%10.4f %-3.2s 0  0  0  0  0  0  0  0  0  0  0  0\n",
                         Atm -> x, Atm -> y, Atm -> z, Atm -> Elem.C) <= 0) {
          Ret = PrintDosErr();
        }
      } /* End of for */

      /**** Bonds ****/

      if (Ret) {
        for(Atm = InizAtm; (Atm && Ret); Atm = Atm -> Ptr) {
          Ord1.L = AttToOrd(Atm);
          for(k = 0; ((Ret) && (k < Atm -> NSost)); ++k) {
            if (Atm -> Conn[k] -> Num > Atm -> Num) {
              Ord2.L = AttToOrd(Atm -> Conn[k]);
              if ((Ord1.L == 0x61720000) && (Ord2.L != 0x61720000)) Ord3.L = 0x31000000;
              else if ((Ord2.L == 0x61720000) && (Ord1.L != 0x61720000)) Ord3.L = 0x31000000;
                   else if (((Ord2.L == 0x616d0000) && (Atm -> Pot.L == FF_TRIPOS_C2)) ||
                            ((Ord1.L == 0x616d0000) && (Atm -> Conn[k] -> Pot.L == FF_TRIPOS_C2))) Ord3.L = 0x616d0000;
                        else if ((VG_ULONG)(Ord1.L) >= (VG_ULONG)(Ord2.L)) Ord3.L = Ord2.L;
                             else Ord3.L = Ord1.L;
#ifdef LITTLE_ENDIAN
              Swap(&Ord3.L);
#endif
              Bond = '1';
              if ((Ord3.C[0] == 'a') && (Ord3.C[1] == 'r'))
                Bond = '4';
              else
                Bond = *Ord3.C;

              if (fprintf(OUT, "%3d%3d  %c  0  0  0  0\n",
                          Atm -> Num, Atm -> Conn[k] -> Num, Bond) <= 0)
                Ret = PrintDosErr();
            }
          } /* End of for */
        } /* End of for */
        if ((Ret) && (fprintf(OUT, "M  END\n") <= 0))
          Ret = PrintDosErr();
      }
    } else Ret = PrintDosErr();
  }

#ifdef __VG_OPENGL
  if (Store) {
    RestoreFF(InizAtm, Store);
    FREE(Store);
  }
#endif

  return Ret;
}

