
/*************************************************
****       VEGA - Mopac loader & Saver        ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#include <ctype.h>
#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "gasteiger.h"


/**** Loader with coordinate translator ****/

ATOMO *MoPacArcLoad(FILE *ARCIN, RECORD *ARCLin, VG_ULONG *TotAtomi)
{
  float      *coord[4], *geo[4], *geol[4];
  float      ccos, cosa;
  float      rbc, xa, xb, xyb, ya, yb, yza, za, zb;
  float      xpa, xpb, ypa, zqa;
/*
  float      xqa;
*/
  float      cosph, sinph, costh, sinth, coskh, sinkh;
  float      cosd, sina, sind;
  float      xd, xpd, xqd, yd, ypd, yqd, zd, zpd, zqd;
  float      xrd;
  int        *na, *nb, *nc;
  int        k, ma, mb, mc;
  VG_ULONG   Count, i;

  ATOMO      *Atm     = NULL;
  ATOMO      *InizAtm = NULL;
  VG_BOOL    Ret      = TRUE;
  VG_ULONG   Tot      = 0;

  for(k = 0;(k < 3) && (fgets(ARCLin -> Line, LINELEN, ARCIN));++k);
  Count = ftell(ARCIN);
  while(fgets(ARCLin -> Line, LINELEN, ARCIN))
    if ((*ARCLin -> Line != '\n') && (strlen(ARCLin -> Line) > 78)) ++Tot;
  fseek(ARCIN, Count, SEEK_SET);


  /**** Allocate the arrays ****/

  Count = (Tot + 1) * sizeof(float);
  for(i = 0;(Ret) && (i <= 3);++i) {
    if ((coord[i] = (float *)Alloca(Count))) {
      if ((geo[i] = (float *)Alloca(Count))) {
        if ((geol[i]  = (float *)Alloca(Count)) == NULL)
          Ret = FALSE;
      } else Ret = FALSE;
    } else  Ret = FALSE;
  }

  if (Ret) {
    Ret   = FALSE;
    Count = (Tot + 1) * sizeof(int);
    if ((na = (int *)Alloca(Count))) {
      if ((nb = (int *)Alloca(Count))) {
        if ((nc = (int *)Alloca(Count))) {

          /**** Load the internal coordinates ****/

          i   = 1;
          Ret = TRUE;
          while(fgets(ARCLin -> Line, LINELEN, ARCIN)) {
            if ((*ARCLin -> Line != '\n') && (strlen(ARCLin -> Line) > 78)) {
              if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
                sscanf(ARCLin -> Line, "%s %f %*s %f %*s %f %*s %d %d %d %f",
                       Atm -> Name.C, &geo[1][i], &geo[2][i], &geo[3][i], &na[i],&nb[i],
                       &nc[i], &Atm -> Charge);
                *Atm -> Elem.C = toupper(*Atm -> Name.C);
                if ((Atm -> Name.C[1]) && (islower(Atm -> Name.C[1])))
                  Atm -> Elem.C[1] = Atm -> Name.C[1];
                ++i;
              } else {
                InizAtm = (ATOMO *)-1;
                break;
              }
            }
          }
          LastAtm = Atm;

          /**** Translate the internal to cartesian coordinates ****/

          if (InizAtm) {
            Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
            for(i = 1;i <= Tot;++i) {
              geol[1][i] = geo[1][i];
              geol[2][i] = geo[2][i] * CONV;
              geol[3][i] = geo[3][i] * CONV;
            }
            coord[1][2] = geol[1][2];

            ccos = cos(geol[2][3]);
            if (na[3] == 1) coord[1][3] = coord[1][1] + geol[1][3] * ccos;
            else coord[1][3] = coord[1][2] - geol[1][3] * ccos;
            coord[2][3] = geol[1][3] * sin(geol[2][3]);

            for(i = 4;i <= Tot;++i) {
              cosa = cos(geol[2][i]);
              mb   = nb[i];
              mc   = na[i];
              xb   = coord[1][mb] - coord[1][mc];
              yb   = coord[2][mb] - coord[2][mc];
              zb   = coord[3][mb] - coord[3][mc];
              rbc  = (float)1.0 /(float)sqrt(xb*xb + yb*yb + zb*zb);

              if (fabs(cosa) >= (float)0.9999999991) {
              	rbc         = geol[1][i] * rbc * cosa;
              	coord[1][i] = coord[1][mc] + xb * rbc;
              	coord[2][i] = coord[2][mc] + yb * rbc;
              	coord[3][i] = coord[3][mc] + zb * rbc;
              } else {
              	ma  = nc[i];
              	xa  = coord[1][ma] - coord[1][mc];
              	ya  = coord[2][ma] - coord[2][mc];
              	za  = coord[3][ma] - coord[3][mc];
              	xyb = sqrt(xb*xb + yb*yb);
              	k   = -1;
              	if (xyb <= (float)0.10) {
                  xpa = za;
                  za  = -xa;
                  xa  = xpa;
                  xpb = zb;
                  zb  = -xb;
                  xb  = xpb;
                  xyb = sqrt(xb*xb + yb*yb);
                  k   = 1;
              	}
              	costh = xb/xyb;
              	sinth = yb/xyb;
              	xpa   = xa * costh + ya * sinth;
              	ypa   = ya * costh - xa * sinth;
              	sinph = zb * rbc;
              	cosph = sqrt(fabs((float)1.00 - sinph * sinph));
/*
              	xqa   = xpa * cosph + za * sinph;
*/
              	zqa   = za * cosph - xpa * sinph;
              	yza   = sqrt(ypa*ypa + zqa*zqa);
              	if ((yza < (float)1.0E-1) && (yza > (float)1.0E-10))
                  CatErr(MSG_ERR_MOPAC_ATMFAULT, i, mc, mb, ma, yza);
              	coskh = ypa/yza;
              	sinkh = zqa/yza;
              	if (yza < (float)1.0E-10) {
                  coskh = (float)1.0;
                  sinkh = 0.0;
              	}
              	sina = sin(geol[2][i]);
              	sind = -sin(geol[3][i]);
              	cosd = cos(geol[3][i]);
              	xd   = geol[1][i] * cosa;
              	yd   = geol[1][i] * sina * cosd;
              	zd   = geol[1][i] * sina * sind;

              	ypd  = yd  * coskh - zd  * sinkh;
              	zpd  = zd  * coskh + yd  * sinkh;
              	xpd  = xd  * cosph - zpd * sinph;
              	zqd  = zpd * cosph + xd  * sinph;
              	xqd  = xpd * costh - ypd * sinth;
              	yqd  = ypd * costh + xpd * sinth;
              	if (k >= 1) {
                  xrd = -zqd;
                  zqd = xqd;
                  xqd = xrd;
              	}
              	coord[1][i] = xqd + coord[1][mc];
              	coord[2][i] = yqd + coord[2][mc];
              	coord[3][i] = zqd + coord[3][mc];
              }
            }

            /**** Copy the coordinates to main array ****/

            Atm = InizAtm;
            for (i = 1;i <= Tot;++i) {
              Atm -> x = coord[1][i];
              Atm -> y = coord[2][i];
              Atm -> z = coord[3][i];
              Atm = Atm -> Ptr;
            }
          }
          FREE(nc);
        }
        FREE(nb);
      }
      FREE(na);
    }
    for(i = 0;i <= 3;++i) {
      if (coord[i]) FREE(coord[i]);
      if (geo[i])   FREE(geo[i]);
      if (geol[i])  FREE(geol[i]);
    }
  }

  if (Ret) return InizAtm;
  else return (ATOMO *)-1;
}

/**** Saver with coordinate translator ****/

VG_BOOL MoPacSave(FILE *OUT, ATOMO *AtmIniz, VG_ULONG Tot, char *OutfileName,
                  char *OutputKeywords)
{
  ATMINT    *IntIniz;
  ATOMO     *Atomo1,*Atomo2;
  char      ComLine[128];
  int       Count, NewCount;
  int       i, j, l, Num;
  VG_UBYTE  Num1, Num2, Num3;
  double    Angle, r, Sum, TOL;

  int       k   = 0;
  VG_BOOL   Ret = TRUE;

  *ComLine = 0;

  if (!*OutputKeywords) {
    if (!GlobSwitch[4]) VegaGetString("Please insert keywords", ComLine, 127);
    if ((*ComLine) && (fprintf(OUT, "%s\n", ComLine) < 0))
      Ret = PrintDosErr();
    else if (fprintf(OUT, "INSERT KEYWORDS\n") < 0) Ret = PrintDosErr();
  } else if (fprintf(OUT, "%s\n", OutputKeywords) < 0) Ret = PrintDosErr();

  if (Ret) {
    if (fprintf(OUT, "%s\n%s\n", OutfileName, VEGAHdr) >= 0) {
      if ((IntIniz = (ATMINT *)Alloca((VG_ULONG)sizeof(ATMINT) * (VG_ULONG)(Tot + 1)))) {
        IntIniz[2].na = 1;
        Atomo1        = AtmIniz;
        for(i = 1; (VG_ULONG)i <= Tot; ++i) {
          IntIniz[i].na  = 2;
          IntIniz[i].nb  = 3;
          IntIniz[i].nc  = 4;
          IntIniz[i].Ptr = Atomo1;
          Num = i - 1;
          if (Num != 0) {
            Sum = 1.0E30;
            Atomo2 = AtmIniz;
            for(j = 1; j <= Num; ++j) {
              r = QuadDist(Atomo1,Atomo2);
              if ((r < Sum) && (IntIniz[j].na != j) && (IntIniz[j].nb != j)) {
                Sum = r;
                k   = j;
              }
              Atomo2 = Atomo2 -> Ptr;
            }
            IntIniz[i].na = k;
            if (i > 2) IntIniz[i].nb = IntIniz[k].na;
            if (i > 3) IntIniz[i].nc = IntIniz[k].nb;
          }
          Atomo1 = Atomo1 -> Ptr;
        }
        IntIniz[1].na = 0;
        IntIniz[1].nb = 0;
        IntIniz[1].nc = 0;
        IntIniz[2].nb = 0;
        IntIniz[2].nc = 0;
        IntIniz[3].nc = 0;

        for(Count = 2;(VG_ULONG)Count <= Tot; ++Count) {
          j = IntIniz[Count].na;
          k = IntIniz[Count].nb;
          l = IntIniz[Count].nc;
          if (Count >= 3) {
            Num = Count;
            IntIniz[Count].w = BondAngle(IntIniz[Num].Ptr, IntIniz[j].Ptr, IntIniz[k].Ptr);
            if (Count >= 4) {
              Angle = BondAngle(IntIniz[Num].Ptr, IntIniz[j].Ptr, IntIniz[k].Ptr);
              TOL = 0.2617994;
              if ((Angle > (PI - TOL)) || (Angle < TOL)) {
                Sum = 0.0;
                for(NewCount = 1; NewCount <= Num - 1;++NewCount) {
                  r = QuadDist(IntIniz[NewCount].Ptr, IntIniz[k].Ptr);
                  if ((r < Sum) && (NewCount != j) && (NewCount != k)) {
                    Angle = BondAngle(IntIniz[Num].Ptr, IntIniz[j].Ptr, IntIniz[k].Ptr);
                    if ((Angle < PI-TOL) && (Angle > TOL)) {
                      Sum               = r;
                      l                 = NewCount;
                      IntIniz[Count].nc = l;
                    }
                  }
                }
                if ((Sum > 99) && (TOL > 0.1)) {
                  TOL = 0.087266;
                  FREE(IntIniz);
                  return CatErr(MSG_ERR_MOPAC_BADCONV);
                }
              }
              IntIniz[Count].t = Torsion(IntIniz[Num].Ptr, IntIniz[j].Ptr,
                                         IntIniz[k].Ptr, IntIniz[l].Ptr);
            }
          }
          IntIniz[Count].r = Distance(IntIniz[Count].Ptr, IntIniz[j].Ptr);
        }
        IntIniz[1].r = 0.0;
        IntIniz[1].w = 0.0;
        IntIniz[1].t = 0.0;
        IntIniz[2].w = 0.0;
        IntIniz[2].t = 0.0;
        IntIniz[3].t = 0.0;

        Atomo1 = AtmIniz;
        for(i = 1; (Ret) && ((VG_ULONG)i <= Tot); i++) {
          switch(i) {
          case 1:
            Num1 = 0;
            Num2 = 0;
            Num3 = 0;
            break;
          case 2:
            Num1 = 1;
            Num2 = 0;
            Num3 = 0;
            break;
          case 3:
            Num1 = 1;
            Num2 = 1;
            Num3 = 0;
            break;
          default:
            Num1 = 1;
            Num2 = 1;
            Num3 = 1;
          }

          if (fprintf(OUT," %-2.2s%12.7f  %d  %12.6f  %d  %12.6f  %d  %3d  %3d  %3d    %8.4f\n",
                      Atomo1 -> Elem.C, IntIniz[i].r, Num1, IntIniz[i].w,Num2, IntIniz[i].t,
                      Num3, IntIniz[i].na, IntIniz[i].nb, IntIniz[i].nc, Atomo1 -> Charge) >= 0)
            Atomo1 = Atomo1 -> Ptr;
          else Ret = PrintDosErr();
        }
        FREE(IntIniz);
      }
    } else Ret = PrintDosErr();
  }

  return Ret;
}


/**** Check anc calculate the total charge ****/

float MoPacChgCalc(ATOMO *InizAtm, VG_ULONG TotAtm)
{
  char                  FFTemp[256];
  register ATOMO        *Atm;
  VG_LONG               *Store;

  float                 Charge = 0.0;

  if (!ChkCharges(InizAtm, TotAtm, &Charge)) {
    if ((Store = StoreFF(InizAtm, TotAtm))) {
      if (GetPrgPath(FFTemp, TRUE)) {
        strcat(FFTemp, FF_UNIV_FILE);
        if (AssignFF(FFTemp, InizAtm, TotAtm, FALSE)) {
          for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
            switch(Atm -> Pot.L) {
            case GAST_C_CAT:	/* Type C+	*/
            case GAST_N_CAT:	/* Type N3+	*/
              Charge += 1.0;
              break;
            case GAST_O_ANI:	/* Type O-	*/
              Charge += -0.5;
              break;
            } /* End of switch */
          } /* End of for */
        }
      }
      RestoreFF(InizAtm, Store);
      FREE(Store);
    }
  }

  return Charge;
}


/**** Check if MMOK option is needed ****/

VG_BOOL MoPacChkMMOK(register ATOMO *Atm, VG_ULONG TotAtomi)
{
  FFDESC     PepDesc[]     = { {{"C"}, 3, 0, 0, 0},
                               {{"O"}, 1, 0, 0, 1},
                               {{"N"}, 9, 0, 0, 1}
                             };

  if ((MatchMtx = (VG_UBYTE *)Alloca(TotAtomi))) {
    while(Atm) {
      if (ChkFFAtm(Atm, &PepDesc[0])) {
        memset(MatchMtx, 0, TotAtomi);
        if ((MatchAtm(Atm, &PepDesc[1], &PepDesc[2])))
          return TRUE;
      }
      Atm = Atm -> Ptr;
    } /* End of while */
    FREE(MatchMtx);
  }

  return FALSE;
}

