
/*************************************************
****     VEGA - Save molecule(s) in a file    ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#include <math.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "formats.h"
#include "ener.h"


/**** Selector of saver routine ****/

VG_BOOL Saver(char *FileName, FILEFORMAT *Form, VG_UWORD PackMode,
              ATOMO *Top, VG_ULONG TotAtomi)
{
  char       MopKeys[256];
  char       *OpenWrtOpt;
  FILE       *OUT;
  float      *Contrib;
  float      MopCharge, LogP, MomLip;
  VG_LONG    *Ptr;
  VG_UWORD   SrfFrm;

  VG_BOOL    Ret           = TRUE;

  const VG_LONG NotStdSv[] = { FORM_CSV_ILM   , FORM_CSV_LOGP  , FORM_CSV_MEP    , FORM_CSV_SRF   ,
                               FORM_QUANTA_MEP, FORM_QUANTA_ILM, FORM_QUANTA_LOGP, FORM_QUANTA_SRF,
                               FORM_BIOSYM_SRF, FORM_VRML_SRF_POINTS,
                               FORM_ENER_CVFF , 0
                             };

  if (!(Form -> Id & FORM_TYPE_PLOT)) {
    if (*FileName) {

     /**** File type extension ****/

      if (!strchr(FileName, '.')) {
        strcat(FileName, ".");
        strcat(FileName, Form -> Ext);
      }
      AddPackExt(FileName, PackMode);

      /**** Select write mode ****/

      switch(Form -> Id) {
      case FORM_QUANTA_MSF:
        OpenWrtOpt = "rb+";
        break;

      case FORM_IFF:
      case FORM_QUANTA_ILM:
      case FORM_QUANTA_LOGP:
      case FORM_QUANTA_MEP:
        OpenWrtOpt = "wb+";
        break;

      default:
        OpenWrtOpt = "w";
      }
      OUT = PkOpen(FileName, OpenWrtOpt, PackMode, TRUE);
    } else OUT = stdout;

    if (OUT) {
      for(Ptr = (VG_LONG *)NotStdSv; (*Ptr) && (*Ptr != Form -> Id); ++Ptr);
      if (!*Ptr) PrintProg(MSG_SAVER_SAVEPROG);
      switch(Form -> Id) {

      case FORM_COMFAFLD:                  /* COMFA field .fld */
        Ret = SybFldCalc(OUT, Top, TotAtomi, &Region);
        break;

      case FORM_PDB:                       /* PDB standard     */
        Ret = PDBSave(OUT, Top, TotAtomi, PDB_PURE);
        break;

      case FORM_PDB_ATDL:                  /* PDB Atdl         */
        Ret = PDBSave(OUT, Top, TotAtomi, PDB_ATDL);
        break;

      case FORM_PDB_NONSTD:                /* PDB non standard */
        Ret = PDBSave(OUT, Top, TotAtomi, PDB_NONSTD);
        break;

      case FORM_BIOSYM_OLD:                /* Old Biosym       */
        Ret = CarSave(OUT, Top, BIOSYM_OLD);
        break;

      case FORM_BIOSYM:                    /* New Biosym       */
        Ret = CarSave(OUT, Top, BIOSYM_NEW);
        break;

      case FORM_IFF:                       /* IFF MOLE File    */
        Ret = IFFSave(OUT, Top, TotAtomi);
        break;

      case FORM_CSSR:                      /* CSSR             */
        Ret = CSSRSave(OUT, Top, TotAtomi, CSSR_PURE);
        break;

      case FORM_MOPINT:                    /* MoPac Internal   */
        if (!Prefs.MOPAC_FLAG) {
          if (Prefs.MOPAC_CRG == (VG_WORD)32000) {
            MopCharge = MoPacChgCalc(Top, TotAtomi);
          } else MopCharge = (float)Prefs.MOPAC_CRG;
#ifdef WIN32
          sprintf(MopKeys, "%s CHARGE=%.0f ", Prefs.MOPAC_DEF,
                MopCharge);
#else
          sprintf(MopKeys, "%s CHARGE=%d ", Prefs.MOPAC_DEF,
                (VG_LONG)rint((double)MopCharge));
#endif
          if (Prefs.MOPAC_MMOK == 2) {
            if (MoPacChkMMOK(Top, TotAtomi))
              strcat(MopKeys, "MMOK");
          } else if (!Prefs.MOPAC_MMOK) strcat(MopKeys, "MMOK");
            else strcat(MopKeys, "NOMM");
        } else strcpy(MopKeys, Prefs.MOPAC_DEF);
        Ret = MoPacSave(OUT, Top, TotAtomi, FileName, MopKeys);
        break;

      case FORM_XYZ:                      /* XYZ              */
        Ret = XyzSave(OUT, Top);
        break;

      case FORM_PDB_Q:                    /* PDBQ             */
        Ret = PDBSave(OUT, Top, TotAtomi, PDB_PDBQ);
        break;

      case FORM_BIOSYM_SRF:               /* Biosym Surface   */
      case FORM_CSV_SRF:                  /* Csv Surface      */
      case FORM_QUANTA_SRF:               /* Quanta Surface   */
        switch(Form -> Id) {
        case FORM_CSV_SRF:
          SrfFrm = SRF_CSV;
          break;

        case FORM_BIOSYM_SRF:
          SrfFrm = SRF_INSIGHT;
          break;

        case FORM_QUANTA_SRF:
          SrfFrm = SRF_QUANTA;
          break;
        } /* End of switch */
        Ret = Surface(OUT, FileName, Top, TotAtomi, Prefs.SAS_POINTS,
                      Prefs.SAS_PROBERAD, SrfFrm|SRF_PROP_VDW, NULL);
        break;

      case FORM_PDB_FAT:                  /* PDBF             */
        Ret = PDBSave(OUT, Top, TotAtomi, PDB_FAT);
        break;

      case FORM_QMC:                      /* QMC              */
        Ret = CSSRSave(OUT, Top, TotAtomi, CSSR_QMC);
        break;

      case FORM_QUANTA_MSF:               /* Quanta MSF       */
        Ret = MsfWrite(OUT, Top, TotAtomi);
        break;

      case FORM_VRML_SRF_POINTS:          /* VRML SRF         */
        Ret = Surface(OUT, FileName, Top, TotAtomi, Prefs.SAS_POINTS,
                      Prefs.SAS_PROBERAD, SRF_VRML_POINTS|SRF_PROP_VDW, NULL);
        break;

      case FORM_VRML_SRF_CPK:             /* VRML SRF CPK     */
        Ret = VrmlCpkSave(OUT, Top, TotAtomi);
        break;

      case FORM_VRML:                     /* VRML             */
        Ret = VrmlSave(OUT, Top, TotAtomi);
        break;

      case FORM_VRML_SOLID:               /* VRML Solid       */
        Ret = VrmlSolSave(OUT, Top, TotAtomi);
        break;

      case FORM_INFO:                     /* Info             */
        Ret = InfoSave(OUT, Top, TotAtomi);
        break;

      case FORM_FASTA:                    /* Fasta            */
        Ret = FastaSave(OUT, Top);
        break;

      case FORM_ENER_CVFF:                /* CVFF energy      */
        Ret = CalcEnerCVFF(OUT, Top, TotAtomi, Prefs.ENRESNAME.L,
                           Prefs.ENRRESSEQ.L, NULL, NULL);
        break;

      case FORM_ALCHEMY:                   /* Tripos Alchemy  */
        Ret = AlchemySave(OUT, Top, TotAtomi);
        break;

      case FORM_CRD:                      /* CHARMm CRD       */
        Ret = CRDSave(OUT, Top, TotAtomi);
        break;

      case FORM_GAMESS:                   /* GAMESS cartesian */
        Ret = GamessSave(OUT, Top, FileName);
        break;

      case FORM_GROMOS:                   /* Gromos Amstrong  */
        Ret = GromosSave(OUT, Top, TotAtomi, 1.0);
        break;

      case FORM_GROMOS_NM:                 /* Gromos nm       */
        Ret = GromosSave(OUT, Top, TotAtomi, 10.0);
        break;

      case FORM_MDL:                      /* MDL Mol          */
        Ret = MdlMolSave(OUT, Top, TotAtomi, FileName);
        break;

      case FORM_MOL2:                     /* Mol2             */
        Ret = Mol2Save(OUT, Top, TotAtomi, FileName);
        break;

      case FORM_CSV_LOGP:                /* Csv LogP         */
      case FORM_QUANTA_LOGP:             /* Quanta LogP      */
        switch(Form -> Id) {
        case FORM_CSV_LOGP:
          SrfFrm = SRF_CSV;
          break;

        case FORM_QUANTA_LOGP:
          SrfFrm = SRF_QUANTA;
          break;
        } /* End of switch */
        if ((Contrib = (float *)Alloca(TotAtomi * sizeof(float)))) {
          PrintProg(MSG_SAVER_ATTYPROG);
          if ((Ret = LogPCalc(Top, TotAtomi, &LogP, &MomLip, "BROTO", Contrib))) {
            if (!GLOBSW_STDOUT) CatPrintf(stdout, MSG_SAVER_LOGPBROTO, LogP, MomLip);
            Ret = Surface(OUT, FileName, Top, TotAtomi, VLOGP_DOT_DENSITY,
                          VLOGP_PROBE_RAD, SrfFrm|SRF_PROP_VLOGP, Contrib);
          }
          FREE(Contrib);
        } else Ret = FALSE;
        break;

      case FORM_CSV_MEP:                 /* Csv MEP           */
      case FORM_QUANTA_MEP:              /* Quanta MEP        */
        switch(Form -> Id) {
        case FORM_CSV_MEP:
          SrfFrm = SRF_CSV;
          break;

        case FORM_QUANTA_MEP:
          SrfFrm = SRF_QUANTA;
          break;
        } /* End of switch */
        Ret = Surface(OUT, FileName, Top, TotAtomi, Prefs.SAS_POINTS,
                      0.0 , SrfFrm|SRF_PROP_MEP, NULL);
        break;

      case FORM_CSV_ILM:                 /* Csv ILM           */
      case FORM_QUANTA_ILM:              /* Quanta ILM        */
        switch(Form -> Id) {
        case FORM_CSV_ILM:
          SrfFrm = SRF_CSV;
          break;

        case FORM_QUANTA_ILM:
          SrfFrm = SRF_QUANTA;
          break;
        } /* End of switch */

        Ret = Surface(OUT, FileName, Top, TotAtomi, Prefs.SAS_POINTS,
                      ILM_PROBE_RAD , SrfFrm|SRF_PROP_ILM, NULL);
        break;
      }
      Ret = PkClose(OUT);

      if (Ret) {
        if ((Form -> Flags & FORM_FLAG_CHKCHG) && (!ChkCharges(Top, TotAtomi, NULL)))
          PrintWarn(GetStr(MSG_SAVER_WARN_NOTCHARGE));
        if((Form -> Flags & FORM_FLAG_CHKFF) && (!ChkForceField(Top, TotAtomi)))
          PrintWarn(GetStr(MSG_SAVER_WARN_FFNOTASS));
      }
    } else Ret = FALSE;
  } else Ret = CatErr(MSG_ERR_SAVER_PLOT);

  return Ret;
}
