
/*************************************************
****            VEGA - CSV Surface            ****
****   Load & save the surface in CSV format  ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <stdio.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"

#ifdef __VG_OPENGL

#include <GL\gl.h>
#include <GL\glu.h>
#include <GL\glaux.h>
#include "gl_global.h"


/**** Load the surface in Quanta format ****/

VG_SURFACE *SrfCsvLoad(FILE *FH, VG_ULONG *TotDots)
{
  char          Buf[256];
  VG_SURFACE    *Dot;
  VG_ULONG      R, G, B;

  VG_SURFACE    *InizSrf = NULL;

  if (BegAtm) {
    if (BegSrf) {
      SrfFree(BegSrf);
      *TotDots = 0;
    }
    while(fgets(Buf, 255, FH)) {
      if ((Dot = AllocSrfDot(&InizSrf, TotDots))) {
        sscanf(Buf, "%d; %f; %f; %f; %f; %d; %d; %d",
               &Dot -> AtmNum, &Dot -> x, &Dot -> y, &Dot -> z,
               &Dot -> Val, &R, &G, &B);
         Dot -> Color[0] = (VG_UBYTE)R;
         Dot -> Color[1] = (VG_UBYTE)G;
         Dot -> Color[2] = (VG_UBYTE)B;
      } else {
        SrfFree(InizSrf);
        InizSrf = NULL;
        TotDots = 0;
        break;
      }
    } /* End of while */

    if (InizSrf) ViewPrefs.SrfAct = TRUE;
  } else CatErr(MSG_ERR_SRFNOMOL);

  return InizSrf;
}
#endif


/**** Save the surface in CSV format ****/

VG_BOOL SrfCsvSave(FILE *FH, register VG_SURFACE *Dot)
{
  VG_BOOL      Ret = TRUE;

  while((Dot) && (Ret)) {
    if (fprintf(FH, "%6d; %15.8f; %15.8f; %15.8f; %15.8f; %3d; %3d; %3d\n",
                Dot -> AtmNum, Dot -> x, Dot -> y, Dot -> z, Dot -> Val,
                (VG_ULONG)Dot -> Color[0], (VG_ULONG)Dot -> Color[1],
                (VG_ULONG)Dot -> Color[2]) <= 0)
      Ret = PrintDosErr();
    Dot = Dot -> Ptr;
  } /* End of while */

  return Ret;
}
