
/**************************************************
****          VEGA - Insight Surface           ****
**** Load & save the surface in Insight format ****
**** Copyright 1996-2002, Alessandro Pedretti  ****
**************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <stdio.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"

#ifdef __VG_OPENGL

#include <GL\gl.h>
#include <GL\glu.h>
#include <GL\glaux.h>
#include "gl_global.h"

/**** Load the surface in Insight format ****/

VG_SURFACE *LoadSrfInsight(FILE *FH, VG_ULONG *TotDots)
{
  char          Buf[256];
  VG_SURFACE    *Dot;

  VG_SURFACE    *InizSrf = NULL;
  VG_ULONG      AtmNum   = 0;

  if (BegAtm) {
    if (BegSrf) {
      SrfFree(BegSrf);
      *TotDots = 0;
    }

    while(fgets(Buf, 255, FH)) {
      if (strncmp(Buf, "ATOM_REF", 8)) {
        if ((Dot = AllocSrfDot(&InizSrf, TotDots))) {
          sscanf(Buf, "%f %f %f %f", &Dot -> x, &Dot -> y, &Dot -> z,
                 &Dot -> Val);
          Dot -> AtmNum = AtmNum;
        } else {
          SrfFree(InizSrf);
          InizSrf = NULL;
          TotDots = 0;
          break;
        }
      } else ++AtmNum;
    } /* End of while */

    if (InizSrf) ViewPrefs.SrfAct = TRUE;
  } else CatErr(MSG_ERR_SRFNOMOL);

  return InizSrf;
}
#endif


/**** Save the surface in Insight format ****/

VG_BOOL SrfInsightSave(FILE *FH, char *File, register VG_SURFACE *Dot, ATOMO *Atm)
{
  char                  FileNam[SRFNAMELEN];
  VG_BOOL               Ret        = TRUE;
  VG_ULONG              NMol       = 1;
  VG_ULONG              PrecAtmNum = 0;

  if (fprintf(FH, "DOTS\n") >= 0) {
    SrfName(File, FileNam);
    Upper(FileNam);
    while(Dot && Ret) {
      if (PrecAtmNum != Dot -> AtmNum) {
        while(Atm) {
          if (Atm -> Flags & VG_ATMF_SEGEND) ++NMol;
          if (Atm -> Num == Dot -> AtmNum) break;
          Atm = Atm -> Ptr;
        } /* End of Atm loop */
        if (fprintf(FH, "ATOM_REF %s:%d:%.4s %.6f %.6f %.6f\n",
                   FileNam, NMol, Atm -> Name.C, Atm -> x, Atm -> y,
                   Atm -> z) < 0)
          Ret = PrintDosErr();
      }
      if ((Ret) && (fprintf(FH, "%.6f %.6f %.6f 120\n", Dot -> x, Dot -> y, Dot -> z) < 0))
        Ret = PrintDosErr();
      PrecAtmNum = Dot -> AtmNum;
      Dot = Dot -> Ptr;
    } /* End of dot loop */
  } else Ret = PrintDosErr();

  return Ret;
}

