
/*************************************************
****          VEGA - Quanta Surface           ****
**** Load & save the surface in Quanta format ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <stdio.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"

#ifdef __VG_OPENGL

#include <GL\gl.h>
#include <GL\glu.h>
#include <GL\glaux.h>
#include "gl_global.h"

#ifdef LITTLE_ENDIAN
#  define  VG_SWAPENDIAN          TRUE
#else
#  define  VG_SWAPENDIAN          FALSE
#endif


/**** Load the surface in Quanta format ****/

VG_SURFACE *LoadSrfQuanta(FILE *FH, VG_ULONG *TotDots)
{
  VG_SURFACE    *Dot;
  VG_ULONG      k, Dots;
  float         PtData[4];

  VG_BOOL       Ret      = TRUE;
  VG_SURFACE    *InizSrf = NULL;
  VG_ULONG      AtmNum   = 0;

  if (BegAtm) {
    if (BegSrf) {
      SrfFree(BegSrf);
      *TotDots = 0;
    }

    if ((Ret = ForSeek(FH, 2, VG_SWAPENDIAN))) {
      do {
        fseek(FH, sizeof(VG_ULONG) * 3, SEEK_CUR);
        if (fread(&Dots, sizeof(VG_ULONG), 1, FH) == 1) {
#ifdef LITTLE_ENDIAN
          Swap(&Dots);
#endif

          while((Ret) && (Dots--)) {
            if ((Dot = AllocSrfDot(&InizSrf, TotDots))) {
              if (fread(&Dot -> x, sizeof(float) * 4, 1, FH) == 1) {
                Dot -> AtmNum = AtmNum;

#ifdef LITTLE_ENDIAN
                Swap(&Dot -> x  );
                Swap(&Dot -> y  );
                Swap(&Dot -> z  );
                Swap(&Dot -> Val);
#endif
                ++*TotDots;
              } else Ret = PrintDosErr();
            } else {
              SrfFree(InizSrf);
              InizSrf = NULL;
              TotDots = 0;
              Ret     = FALSE;
            }
          } /* End of dot loop */
          if (Ret)
            fseek(FH, sizeof(VG_ULONG), SEEK_CUR);
        } else break;
        ++AtmNum;
      } while(Ret); /* End of main loop */
    }

    if (InizSrf) ViewPrefs.SrfAct = TRUE;
  } else CatErr(MSG_ERR_SRFNOMOL);

  return InizSrf;
}
#endif


/**** Save the surface in Quanta format ****/

VG_BOOL SrfQuantaSave(FILE *FH, char *File, register VG_SURFACE *Dot, ATOMO *Atm)
{
  char                  FileNam[SRFNAMELEN];
  VG_ULONG              k;

  VG_BOOL               Ret        = TRUE;
  VG_ULONG              j          = 0;
  VG_ULONG              NMol       = 1;
  VG_ULONG              PosFor     = 0;
  VG_ULONG              PrecAtmNum = 0;

#ifdef LITTLE_ENDIAN
  static const VG_ULONG    Uno      = 0x01000000;
#else
  static const VG_ULONG    Uno      = 1;
#endif

  SrfName(File, FileNam);
  strcat(FileNam, ".msf");
  k = strlen(FileNam);
  memset(FileNam + k, ' ', 100 - k);

  /**** Write the header ****/

  if (((Ret = ForWrite(FH, (void *)&Uno, sizeof(VG_ULONG)))) &&
       ((Ret = ForWrite(FH, FileNam, 100)))) {
     while((Dot) && (Ret)) {
      if ((PrecAtmNum != Dot -> AtmNum) || (!Dot -> Ptr)) {
        while(Atm) {
          if (Atm -> Flags & VG_ATMF_SEGEND) ++NMol;
          if (Atm -> Num == Dot -> AtmNum) break;
          Atm = Atm -> Ptr;
        } /* End of Atm loop */

        if (j) {
          fseek(FH, PosFor, SEEK_SET);
          k = j * sizeof(float) * 4 + sizeof(VG_ULONG) * 3;
          if (SwapWrite(FH, &k) == 1) {
            fseek(FH, sizeof(VG_ULONG) * 2, SEEK_CUR);
            if (SwapWrite(FH, &j) == 1) {
              k = j * sizeof(float) * 4 + sizeof(VG_ULONG) * 3;
              fseek(FH, 0, SEEK_END);
              if (SwapWrite(FH, &k) != 1)
                Ret = PrintDosErr();
            } else Ret = PrintDosErr();
          } else Ret = PrintDosErr();
        }

        if (Ret) {
          j          = 0;
          PosFor     = ftell(FH);
          if ((fwrite(&j, sizeof(VG_ULONG), 1, FH) != 1) ||  /* Header of fortran record */
              (SwapWrite(FH, &Dot -> AtmNum) != 1) ||        /* Number of current atom   */
              (SwapWrite(FH, &NMol) != 1) ||                 /* Number of molecule       */
              (fwrite(&j, sizeof(VG_ULONG), 1, FH) != 1))    /* Number of dots           */
            Ret = PrintDosErr();
         }
      }

      if ((Ret) &&
          (SwapWrite(FH, &Dot -> x) == 1) &&
          (SwapWrite(FH, &Dot -> y) == 1) &&
          (SwapWrite(FH, &Dot -> z) == 1) &&
          (SwapWrite(FH, &Dot -> Val) == 1))
        ++j;
      else Ret = PrintDosErr();
      PrecAtmNum = Dot -> AtmNum;
      Dot        = Dot -> Ptr;
    } /* End of dot loop */
  }

  return Ret;
}

