
/*************************************************
****        VEGA - XYZ loader & saver         ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/


#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"


/**** XYZ Loader ****/

ATOMO *XyzLoad(FILE *FH, RECORD *Lin, VG_ULONG *TotAtomi)
{
  ATOMO		   *InizAtm = NULL;
  register ATOMO   *Atm     = NULL;

  do {
    if (*Lin -> Line != '\n') {
      if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
        sscanf(Lin -> Line, "%2s %f %f %f",
               Atm -> Name.C, &Atm -> x, &Atm -> y, &Atm -> z);
        Atm -> Elem.C[0] = (char)toupper(Atm -> Name.C[0]);
        if (Atm -> Name.C[1]) Atm -> Elem.C[1] = (char)tolower(Atm -> Name.C[1]);
      } else break;
    }
  } while(fgets(Lin -> Line, LINELEN, FH));
  if (Atm) {
    Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
    LastAtm       = Atm;
  }

  return InizAtm;
}


/**** XYZ Saver ****/

VG_BOOL XyzSave(FILE *FH, register ATOMO *Atm)
{
  VG_BOOL		Ret = TRUE;

  while((Ret) && (Atm)) {
    if (fprintf(FH, "  %-2.2s %13.5f  %13.5f  %13.5f\n",
                Atm -> Elem.C, Atm -> x, Atm -> y, Atm -> z) < 0)
      Ret = PrintDosErr();
    Atm = Atm -> Ptr;
  } /* End of atom loop */

  return Ret;
}
