/*
 * $Id: xdrf.h,v 1.11.2.1 2002/04/01 20:19:48 lindahl Exp $
 * 
 *                This source code is part of
 * 
 *                 G   R   O   M   A   C   S
 * 
 *          GROningen MAchine for Chemical Simulations
 * 
 *                        VERSION 3.1
 * Copyright (c) 1991-2001, University of Groningen, The Netherlands
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * If you want to redistribute modifications, please consider that
 * scientific software is very special. Version control is crucial -
 * bugs must be traceable. We will be happy to consider code for
 * inclusion in the official distribution, but derived work must not
 * be called official GROMACS. Details are found in the README & COPYING
 * files - if they are missing, get the official version at www.gromacs.org.
 * 
 * To help us fund GROMACS development, we humbly ask that you cite
 * the papers on the package - you can find them in the top README file.
 * 
 * For more info, check our website at http://www.gromacs.org
 * 
 * And Hey:
 * Getting the Right Output Means no Artefacts in Calculating Stuff
 */

#ifndef _xdrf_h
#define _xdrf_h

typedef float   real;

#ifdef __PGI    /*Portland group compiler*/
#define int64_t long long
#endif

#if (defined WIN32 || defined _WIN32 || defined _WINDOWS || defined WINDOWS)
#  define INCLUDE_GMX_SYSTEM
#  ifdef XDRF_DLL
#    include <windows.h>
#    ifdef __MINGW32__
#        define  XDREXPORT
#        define  XDREXTERN       __declspec(dllexport)
#    else
#      define  XDREXPORT         __declspec(dllexport) WINAPI
#    endif
#  endif
#else
#  ifdef AMIGA
#  define INCLUDE_GMX_SYSTEM
#  else
#  include <rpc/rpc.h>
#  include <rpc/xdr.h>
#  endif
#endif

#ifndef XDREXTERN
#  define  XDREXTERN        extern
#endif

#ifndef XDREXPORT
#  define  XDREXPORT
#endif

#ifdef INCLUDE_GMX_SYSTEM
#  include "gmx_system_xdr.h"
#endif

/**** Prototypes ****/

/* Read or write reduced precision *float* coordinates */

XDREXTERN int XDREXPORT xdr3dfcoord(XDR *, float *, int *, float *);

/* Read or write reduced precision *real* coordinates */

XDREXTERN int XDREXPORT xdr3drcoord(XDR *, real *, int *, real *);

/* Close a xdr stream */

XDREXTERN int XDREXPORT xdrclose(XDR *);

/* Return the XDR error code */

XDREXTERN int XDREXPORT xdrerror(void);

/* Return the XDR error string */

XDREXTERN char * XDREXPORT xdrerrorstr(int);

/* Open a xdr stream */

XDREXTERN int XDREXPORT xdropen(XDR *, const char *, const char *);

/* Read or write a *real* value (stored as float) */

XDREXTERN int XDREXPORT xdr_real(XDR *, real *);

/* Seek the XDR stream (see fseek) */

XDREXTERN int XDREXPORT xdrseek(XDR *, long, int);


/**** Error codes ****/

#define  XDR_ERR_OK               0  /* All rights                                     */
#define  XDR_ERR_UNK              1  /* Unknown error                                  */
#define  XDR_ERR_OPENOVERFLOW     2  /* Max number of opened file reached              */
#define  XDR_ERR_OPEN             3  /* Can't open file                                */
#define  XDR_ERR_NOOPEN           4  /* No such open xdr file                          */
#define  XDR_ERR_NULLHANDLE       5  /* Null handle                                    */
#define  XDR_ERR_SENDINTS         6  /* Major breakdown in sendints                    */
#define  XDR_ERR_OUTOFMEM         7  /* Out of memory                                  */
#define  XDR_ERR_NUMCOORD         8  /* Wrong number of coordinates                    */
#define  XDR_ERR_FLOATORDER       9  /* Error when detecting floating-point word order */
#define  XDR_ERR_DOS             10  /* DOS error */

#endif






